<?php

use App\Http\Controllers\Admin\AbonosController;
use App\Http\Controllers\Admin\AgendaController;
use App\Http\Controllers\Admin\ArticuloController;
use App\Http\Controllers\Admin\ArticuloKanausController;
use App\Http\Controllers\Admin\BodegaKanausController;
use App\Http\Controllers\Admin\CajaContrller;
use App\Http\Controllers\Admin\CajaSecuntariaController;
use App\Http\Controllers\Admin\CategoriaController;
use App\Http\Controllers\Admin\ColoresController;
use App\Http\Controllers\Admin\CompraController;
use App\Http\Controllers\Admin\ConsentimientosController;
use App\Http\Controllers\Admin\DescuentoDoctorController;
use App\Http\Controllers\Admin\DiarioController;
use App\Http\Controllers\Admin\DoctoreController;
use App\Http\Controllers\Admin\EscanerController;
use App\Http\Controllers\Admin\FotoPacienteController;
use App\Http\Controllers\Admin\FotoTratamientoController;
use App\Http\Controllers\Admin\GraficaController;
use App\Http\Controllers\Admin\InsumoController;
use App\Http\Controllers\Admin\LaboratorioController;
use App\Http\Controllers\Admin\MobiliarioEquipoController;
use App\Http\Controllers\Admin\OrtodonciaController;
use App\Http\Controllers\Admin\PacienteController;
use App\Http\Controllers\Admin\PagoFacturaController;
use App\Http\Controllers\Admin\PagoTratamientoController;
use App\Http\Controllers\Admin\PeriodontogramaController;
use App\Http\Controllers\Admin\PresupuestoController;
use App\Http\Controllers\Admin\ProtecisController;
use App\Http\Controllers\Admin\ProveedorController;
use App\Http\Controllers\Admin\RecetaController;
use App\Http\Controllers\Admin\RecordatorioGeneralController;
use App\Http\Controllers\Admin\SalidaInsumoController;
use App\Http\Controllers\Admin\SolicitudController;
use App\Http\Controllers\Admin\TratamientoController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\VentaKanausController;
use App\Http\Controllers\Admin\VentasController;
use App\Http\Controllers\Web\DataController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [DataController::class, 'home']);

Auth::routes();

// rauta para ejecutar comando artisan desde la web
Route::get('artisan/{comando}/{contra}', function ($comando, $contra) {
    if ($contra === 'Taylor110eAA.') {
        // ejemplo www.decodev.net/cmd/migrate
        Artisan::call($comando);
        dd(Artisan::output());
    } else {
        echo 'NO ACCESO';
    }
});

// 'as' => 'admin.', esto es para anadir por defecto un nombre a las rutas

Route::group(['prefix' => "admin",  'namespace' => 'App\Http\Controllers\Admin', 'middleware' => ['auth', 'AdminPanelAccess']], function () {

    Route::get('/', 'HomeController@index')->name('home');

    Route::resource('/users', 'UserController');
    Route::prefix('/user')->group(function () {
        Route::get('actividades', [UserController::class, 'actividades'])->name('users.actividades')->middleware('can:usuario_actividades');
        Route::post('actividades', [UserController::class, 'storeActividad'])->name('users.storeActividad')->middleware('can:usuario_storeActividad');
        Route::delete('actividades/{id}', [UserController::class, 'deleteactividad'])->name('users.deleteactividad')->middleware('can:usuario_actividaddelete');
        Route::get('check/list/{id}', [UserController::class, 'checkList'])->name('users.checkList')->middleware('can:usuario_checklist');
        Route::get('check/cambio/{id}', [UserController::class, 'cabiarCheck'])->name('users.cabiarCheck')->middleware('can:usuario_cabiarCheck');
        Route::get('report', [UserController::class, 'userReport'])->name('users.userReport')->middleware('can:users_userReport');
        Route::get('report-operaciones', [UserController::class, 'reportAcciones'])->name('users.reportAcciones')->middleware('can:users_userReport');
        Route::post('check/list', [UserController::class, 'reporteChekListo'])->name('users.reporteChekListo')->middleware('can:users_userReport');
    });



    Route::resource('/roles', 'RoleController');
    Route::resource('/permissions', 'PermissionController')->except(['show']);


    // rutas para pacientes
    Route::resource('/pacientes', 'PacienteController');
    Route::prefix('paciente')->group(function () {
        Route::get('/activos', [PacienteController::class, 'pacientesActivos'])->name('pacientes.activos');
        Route::get('/paciente-ajax', [PacienteController::class, 'getAjaxPaciente'])->name('pacientes.getAjaxPaciente');
        Route::get('/inactivos', [PacienteController::class, 'pacientesInactivos'])->name('pacientes.inactivos');
        Route::get('/registro', [PacienteController::class, 'registroTablet'])->name('pacientes.registroTablet')->middleware('can:paciente_store');
        Route::get('/registro/igss', [PacienteController::class, 'registroIgss'])->name('pacientes.registroIgss')->middleware('can:paciente_store');
        Route::post('/registro/igss/store', [PacienteController::class, 'registroIgssStore'])->name('pacientes.registroIgssStore')->middleware('can:paciente_store');
        Route::get('/registro/privado', [PacienteController::class, 'registroPrivado'])->name('pacientes.registroPrivado')->middleware('can:paciente_store');
        Route::post('/registro/privado', [PacienteController::class, 'registroPrivadoStore'])->name('pacientes.registroPrivadoStore')->middleware('can:paciente_store');


        Route::get('/abonos-realizados', [PacienteController::class, 'abono_dia'])->name('pacientes.abono_dia');

        // deudores
        Route::get('/deudores', [PacienteController::class, 'deudores'])->name('pacientes.deudores')->middleware('can:paciente_deudores');

        // reportes
        Route::get('/reportes', [PacienteController::class, 'reportes'])->name('pacientes.reportes');
        Route::get('/reportes/pacientes-todos', [PacienteController::class, 'reportall'])->name('pacientes.reportall');
        Route::get('/reportes/pacientes-activos', [PacienteController::class, 'reportActivos'])->name('pacientes.reportActivos');
        Route::get('/reportes/pacientes-inactivos', [PacienteController::class, 'reportInactivos'])->name('pacientes.reportInactivos');
        Route::get('/reportes/pacientes/deudores', [PacienteController::class, 'printDeudores'])->name('pacientes.printDeudores')->middleware('can:paciente_deudores');
        Route::get('/ficha/clinica/{id}', [PacienteController::class, 'printFicha'])->name('pacientes.printFicha');


        // radiografias
        Route::prefix('readiografa')->group(function () {
            Route::get('eliminar/{id}', [FotoPacienteController::class, 'delete'])->name('paciente.readiografiadelete');
            Route::get('/{id}', [FotoPacienteController::class, 'radiografias'])->name('paciente.radiografia');
            Route::post('', [FotoPacienteController::class, 'store'])->name('paciente.radiografiastore');
        });

        // laboratorio
        Route::prefix('laboratorio')->group(function () {
            Route::get('eliminar/{id}', [LaboratorioController::class, 'pacienteDelete'])->name('paciente.pacienteDelete');
            Route::get('/{id}', [LaboratorioController::class, 'paciente'])->name('paciente.paciente');
            Route::post('', [LaboratorioController::class, 'pacienteStore'])->name('paciente.labpacienteStore');
        });

        Route::prefix('diario')->group(function () {
            Route::get('/{id}', [DiarioController::class, 'index'])->name('diario.index');
            Route::post('', [DiarioController::class, 'store'])->name('diario.store');
            Route::delete('/{id}', [DiarioController::class, 'destroy'])->name('diario.destroy');
        });

        // guarda la firma de un paciente
        Route::post('set/firma', [PacienteController::class, 'setFirma'])->name('paciente.setFirma');

        Route::get('firma-nueva/{id}', [PacienteController::class, 'setReFirma'])->name('paciente.setReFirma');

        // periodontograma
        Route::get('periodontograma/{id}', [PeriodontogramaController::class, 'index'])->name('perio.index');
        Route::post('periodontograma', [PeriodontogramaController::class, 'store'])->name('perio.store');


        // nueva vista de ingraso de Presupuesto
        Route::get('ingreso-presupuesto/{id}', [PresupuestoController::class, 'new_presu'])->name('pac.new_presu');
        Route::get('search-ajax', [PresupuestoController::class, 'getTratamientoAjax'])->withoutMiddleware(['auth', 'AdminPanelAccess'])->name('pac.getTratamientoAjax');


        // recordatorios
        Route::get('recordatorios/{id}', [PacienteController::class, 'recordatorios'])->name('recopa.recordatorios');
        Route::post('recordatorio', [PacienteController::class, 'recordatorio'])->name('recopa.recordatorio');
        Route::delete('delete_recordatorio/{id}', [PacienteController::class, 'delete_recordatorio'])->name('recopa.delete_recordatorio');
    });

    // rutas de presupuestos
    Route::prefix('procedimiento')->group(function () {
        Route::post('', [PresupuestoController::class, 'store'])->name('presup.store');
        Route::delete('/{id}', [PresupuestoController::class, 'delete'])->name('presup.delete');
        Route::get('/{id}', [PresupuestoController::class, 'pritPresupuesto'])->name('presup.pritPresupuesto');
        Route::get('asignar/{id}', [PresupuestoController::class, 'procedimientosPrint'])->name('presup.procedimientosPrint');


        Route::get('restore/{id}', [PresupuestoController::class, 'restore'])->name('presup.restore');


        Route::put('actualizar/datos', [PresupuestoController::class, 'updatePresupuesto'])->name('presup.updatePresupuesto');

        Route::post('asignar/pago', [PresupuestoController::class, 'setProcedimientoAndPago'])->name('presup.setProcedimientoAndPago');
        Route::delete('eliminar/pago', [PresupuestoController::class, 'deleteProcedimientoAndPago'])->name('presup.deleteProcedimientoAndPago');

        Route::get('presupuesto/agrupado/{id}', [PresupuestoController::class, 'agurpar_presupuesto'])->name('presup.agrupado');
    });



    // rutas abonos
    Route::prefix('abonos')->group(function () {
        Route::get('/recibo/{id}', [AbonosController::class, 'pritnRecibo'])->name('abono.pritnRecibo')->middleware('can:abono_recibo');
        Route::get('/{paciente}/{id}', [AbonosController::class, 'abonar'])->name('abono.abonar');
        Route::post('', [AbonosController::class, 'store'])->name('abono.store')->middleware('can:abono_store');
        Route::get('/{id}', [AbonosController::class, 'delete'])->name('abono.delete')->middleware('can:abono_delete');
    });


    // rutas abonos
    Route::prefix('salida-insumo')->group(function () {
        Route::get('index/{id}/{id2}', [SalidaInsumoController::class, 'index'])->name('si.index');
        Route::post('store', [SalidaInsumoController::class, 'salidaInsutmoStore'])->name('si.salidaInsutmoStore');
        Route::get('search-ajax', [SalidaInsumoController::class, 'searchAjax'])->name('si.searchAjax');
        Route::get('search-getLoteData', [SalidaInsumoController::class, 'getLoteData'])->name('si.getLoteData');
    });

    // rutas para caja
    Route::group(['prefix' => 'caja'], function () {
        Route::get('entradas', [CajaContrller::class, 'showEntrdas'])->name('caja.entradas');
        Route::get('salidas', [CajaContrller::class, 'showSalidas'])->name('caja.salidas');
        Route::get('cuadre', [CajaContrller::class, 'cuadre'])->name('caja.cuadre')->middleware('can:caja_cuadre');
        Route::post('cuadre/store', [CajaContrller::class, 'cuadreStore'])->name('caja.cuadreStore')->middleware('can:caja_cuadre');
        Route::post('salidas/registro', [CajaContrller::class, 'salida'])->name('caja.salidaStore')->middleware('can:caja_registro_gastos');
        Route::post('entradas/registro', [CajaContrller::class, 'entrada'])->name('caja.entradaStore')->middleware('can:caja_registro_cajachica');
        Route::get('cuadre/delete/{id}', [CajaContrller::class, 'deleteCuadre'])->name('caja.deleteCuadre')->middleware('can:caja_cuadre_delete');
        Route::get('entrada/delete/{id}', [CajaContrller::class, 'entradaDelete'])->name('caja.deleteentrada')->middleware('can:caja_delete_cajachica');
        Route::get('salida/delete/{id}', [CajaContrller::class, 'salidaDelete'])->name('caja.deletesalida')->middleware('can:caja_delete_gasto');

        // reporte de Movimientos
        Route::get('cuadre/report', [CajaContrller::class, 'cuadrereport'])->name('caja.cuadreReport');
        Route::get('movimientos', [CajaContrller::class, 'movimientos'])->name('caja.movimientos');
        Route::post('movimientos/salidas', [CajaContrller::class, 'salidaReport'])->name('caja.salidaReport')->middleware('can:caja_filtrado_gastos');
        Route::post('movimientos/entradas', [CajaContrller::class, 'entradasReport'])->name('caja.entradasReport')->middleware('can:caja_filtrado_cajachica');
        // para buscar cuadres por fehca
        Route::get('movimientos/filtro', [CajaContrller::class, 'cuadrereportFilter'])->name('caja.cuadrereportFilter')->middleware('can:caja_movimientos_filtrados');
        // para veer los movimietnos de dicho cuadre
        Route::get('movimientos/fecha/{fecha}', [CajaContrller::class, 'cuadreFecha'])->name('caja.cuadreFecha')->middleware('can:caja_movimientos_dia');
        // para imprimir el cuadre impresora termica
        Route::get('cuadre/{id}', [CajaContrller::class, 'printCuadre'])->name('caja.printCuadre');
        // imprimir los movimiento de la clinica por fecha
        Route::post('movimientos-dia', [CajaContrller::class, 'movimientos_dia'])->name('caja.movimientos_dia');
        Route::post('movimientos-entre-dias', [CajaContrller::class, 'moviemintentoToDates'])->name('caja.moviemintentoToDates');




        Route::get('cuadre-ortodoncia', [CajaContrller::class, 'cuadreOrto'])->name('caja.cuadreOrto');
        Route::post('cuadre-ortodoncia-store', [CajaContrller::class, 'cuadre_ortodoncia_store'])->name('caja.cuadre_ortodoncia_store');

        Route::get('print-cuadre-orto/{id}', [CajaContrller::class, 'printCuadreOrto'])->name('caja.printCuadreOrto');

        // retorna el cuadre de caja para ventas de medicamentos
        Route::get('cuadre-medicamento', [CajaContrller::class, 'cuadre_medicamentos'])->name('caja.cuadre_medicamentos');
        Route::post('cuadre-medicamento-store', [CajaContrller::class, 'cuadre_med_store'])->name('caja.cuadre_med_store');

        Route::get('print-cuadre-medicamento/{id}', [CajaContrller::class, 'printCuadreMedi'])->name('caja.printCuadreMedi');
    });

    // rutas caja secundaria
    Route::prefix('caja-secundaria')->group(function () {
        Route::get('/', [CajaSecuntariaController::class, 'index'])->name('caja-secundaria.index');
        Route::get('/crear', [CajaSecuntariaController::class, 'create'])->name('caja-secundaria.create');
        Route::post('/almacenar', [CajaSecuntariaController::class, 'store'])->name('caja-secundaria.store');
        Route::get('/{cajaSecundaria}', [CajaSecuntariaController::class, 'show'])->name('caja-secundaria.show');
        Route::get('/{cajaSecundaria}/editar', [CajaSecuntariaController::class, 'edit'])->name('caja-secundaria.edit');
        Route::put('/{cajaSecundaria}', [CajaSecuntariaController::class, 'update'])->name('caja-secundaria.update');
        Route::delete('/{cajaSecundaria}', [CajaSecuntariaController::class, 'destroy'])->name('caja-secundaria.destroy');
    });

    // rutas medicamentos
    Route::group(['prefix' => 'medicamentos'], function () {
        Route::get('inicio', [ArticuloController::class, 'index'])->name('articulo.index')->middleware('can:medicamento_listado');
        Route::get('inicio-db', [ArticuloController::class, 'updateDB'])->name('articulo.updateDB')->middleware('can:medicamento_show');
        Route::get('medicamento/{id}', [ArticuloController::class, 'show'])->name('articulo.show')->middleware('can:medicamento_show');
        Route::get('nuevo', [ArticuloController::class, 'create'])->name('articulo.nuevo')->middleware('can:medicamento_store');
        Route::post('store', [ArticuloController::class, 'store'])->name('articulo.store')->middleware('can:medicamento_store');
        Route::put('update/{id}', [ArticuloController::class, 'update'])->name('articulo.update')->middleware('can:medicamento_show');
        Route::get('delete/{id}', [ArticuloController::class, 'destroy'])->name('articulo.delete')->middleware('can:medicamento_delete');
        Route::get('control/stock', [ArticuloController::class, 'controlStock'])->name('articulo.stock')->middleware('can:medicamento_min_stock');
        // compra de articulos

        Route::get('comprar', [CompraController::class, 'index'])->name('articulo.comprar')->middleware('can:medicamento_compra_store');
        Route::post('compra', [CompraController::class, 'store'])->name('articulo.compraStore')->middleware('can:medicamento_compra_store');


        Route::get('historial/compra', [CompraController::class, 'shows'])->name('articulo.comprarHisto')->middleware('can:medicamento_historial');
        Route::get('historial/compra/delete/{id}/{idArt}', [CompraController::class, 'delete'])->name('articulo.compradelete')->middleware('can:medicamento_hitorial_delete');


        // reportes
        Route::get('compras/reporte', [CompraController::class, 'report'])->name('articulo.compraReport')->middleware('can:medicamento_report_all');
        Route::get('reportes', [ArticuloController::class, 'reportes'])->name('articulo.repotes')->middleware('can:medicamento_report_all');
        Route::get('reportes/all', [ArticuloController::class, 'reportAll'])->name('articulo.repotesAll')->middleware('can:medicamento_report_all');
        Route::get('reportes/allmin', [ArticuloController::class, 'reportAllmin'])->name('articulo.repotesAllmin')->middleware('can:medicamento_report_all');
        Route::get('reportes/control/stock', [ArticuloController::class, 'stockControl'])->name('articulo.stockControl')->middleware('can:medicamento_report_all');
        Route::get('reportes/control/stock/salidas', [ArticuloController::class, 'articulosvendidos'])->name('articulo.articulosvendidos')->middleware('can:medicamento_report_all');

        // Export Data
        Route::get('articulo/data/{id}', [ArticuloController::class, 'dataPrint'])->name('articulo.exportdata');
    });

    // rutas categorias
    Route::group(['prefix' => 'categorias'], function () {
        Route::get('incio', [CategoriaController::class, 'index'])->name('categoria.index')->middleware('can:categoria_list');
        Route::get('delete/{id}', [CategoriaController::class, 'delete'])->name('categoria.delete')->middleware('can:categoria_delete');
        Route::get('show/{id}', [CategoriaController::class, 'show'])->name('categoria.show')->middleware('can:categoria_show');
        Route::put('update/{id}', [CategoriaController::class, 'update'])->name('categoria.update')->middleware('can:categoria_show');
        Route::post('store', [CategoriaController::class, 'store'])->name('categoria.store')->middleware('can:categoria_create');
        Route::get('create', [CategoriaController::class, 'create'])->name('categoria.create')->middleware('can:categoria_create');
        Route::get('reporte', [CategoriaController::class, 'reporte'])->name('categoria.reporte')->middleware('can:categoria_report');
    });


    // SOLICITUD DE COMPRAS
    Route::group(['prefix' => 'solicitudas'], function () {
        Route::get('incio', [SolicitudController::class, 'index'])->name('soli.index');
        Route::post('store', [SolicitudController::class, 'store'])->name('soli.store');
        Route::put('update/{id}', [SolicitudController::class, 'update'])->name('soli.update');
        Route::delete('delete/{id}', [SolicitudController::class, 'delete'])->name('soli.delete');
    });

    // rutas para  proveedores
    Route::group(['prefix' => 'proveedor'], function () {
        Route::get('inicio', [ProveedorController::class, 'index'])->name('prove.index');
        Route::get('create', [ProveedorController::class, 'create'])->name('prove.create');
        Route::post('create', [ProveedorController::class, 'store'])->name('prove.store');
        Route::put('update/{id}', [ProveedorController::class, 'update'])->name('prove.update');
        Route::get('show/{id}', [ProveedorController::class, 'show'])->name('prove.show');
        Route::get('reportes', [ProveedorController::class, 'reporte'])->name('prove.reporte');

        // facturas
        Route::post('factura/create', [ProveedorController::class, 'facturacreate'])->name('prove.facturacreate');
        Route::get('factura/delete/{id}', [ProveedorController::class, 'facturadelete'])->name('prove.facturadelete');

        // abonos
        Route::get('factura/abonos/{id}', [ProveedorController::class, 'abonos'])->name('prove.abonos');
        Route::post('abonar', [ProveedorController::class, 'abonoRegistro'])->name('prove.abonar');
        Route::get('abono/delete/{id}', [ProveedorController::class, 'deleteAbono'])->name('prove.deleteAbono');
        // compra a proveedores
        Route::get('mas/comprado/{id}', [ProveedorController::class, 'mascomprado'])->name('prove.mascomprado');
        Route::get('delete/{id}', [ProveedorController::class, 'delete'])->name('prove.delete');
    });

    // rutas para doctores
    Route::resource('/doctores', 'DoctoreController');
    Route::prefix('doctor')->group(function () {
        Route::get('/reportes', [DoctoreController::class, 'reportes'])->name('doctores.reportes')->middleware('can:doctor_reportes');
        Route::get('/reporte/todos', [DoctoreController::class, 'reporteAllDoctor'])->name('doctores.reporteAllDoctor');
        Route::get('/reportes/eliminados', [DoctoreController::class, 'reportAllDelete'])->name('doctores.reportAllDelete');
        Route::get('/reporte/pagos/{id}', [DoctoreController::class, 'prindPagos'])->name('doctores.prindPagos')->middleware('can:doctor_pagosprint');
    });



    // rutas  ventas
    Route::group(['prefix' => 'ventas'], function () {
        Route::get('index', [VentasController::class, 'index'])->name('venta.index')->middleware('can:venta_inicio');
        Route::post('store', [VentasController::class, 'store'])->name('venta.store')->middleware('can:venta_inicio');
        Route::get('pagar/credito/{id}', [VentasController::class, 'pagarCredito'])->name('venta.pagar');
        Route::get('factura/print/{idFactura}', [VentasController::class, 'ventaPrint'])->name('venta.facturaPrint')->middleware('can:venta_recibo');
        Route::get('historial/ventas', [VentasController::class, 'historial'])->name('venta.historial')->middleware('can:venta_historial');
        Route::get('anular/{id}/{idArt}', [VentasController::class, 'destroy'])->name('venta.delete')->middleware('can:venta_anulacion');

        // reportes
        Route::get('reportes', [VentasController::class, 'reportes'])->name('venta.reportes');
        Route::get('reportes/ventas', [VentasController::class, 'reportesVentasAll'])->name('venta.reportesAll')->middleware('can:venta_reports');
        Route::get('reportes/ventas/contado', [VentasController::class, 'reportesVentasContado'])->name('venta.reportesAlContado')->middleware('can:venta_reports');
        Route::get('reportes/ventas/crediro', [VentasController::class, 'reportesVentasCredito'])->name('venta.reportesAlCrediro')->middleware('can:venta_reports');
        Route::get('reporte/dia', [VentasController::class, 'ventasDia'])->name('venta.diaReport')->middleware('can:venta_reports');
        Route::get('reporte/movimientos', [VentasController::class, 'movimientos'])->name('venta.movimientos')->middleware('can:venta_reports');
        Route::get('estadistica', [VentasController::class, 'estadistica'])->name('venta.estadistica')->middleware('can:venta_reports');
    });

    // rutas tratamientos
    Route::resource('tratamiento', 'TratamientoController');
    Route::prefix('tratamientos')->group(function () {
        Route::get('reportes',  [TratamientoController::class, 'reportes'])->name('tratamientos.reportes')->middleware('can:tratamiento_report');
        Route::get('cahanche-estado/{procedimiento_id}',  [TratamientoController::class, 'desbloquear'])->name('tratamientos.desbloquear');
        Route::get('reportes/mas-menos',  [TratamientoController::class, 'masToMinus'])->name('tratamientos.masToMinus')->middleware('can:tratamiento_report');
        Route::get('reportes/faltantes',  [TratamientoController::class, 'faltantesOperacion'])->name('tratamientos.faltantesOperacion')->middleware('can:tratamiento_report');
        Route::get('reportes/totales',  [TratamientoController::class, 'totalTratamiento'])->name('tratamientos.totalTratamiento')->middleware('can:tratamiento_report');
        Route::get('reportes/todos',  [TratamientoController::class, 'printAll'])->name('tratamientos.printAll');
        Route::get('reportes/salida-insumos',  [TratamientoController::class, 'salidadeinsumoentratamiento'])->name('tratamientos.salidadeinsumoentratamiento');
    });

    // rutas para pagos de tratamientos
    Route::resource('pagos', 'PagoTratamientoController');
    Route::prefix('pago')->group(function () {
        Route::get('reporte', [PagoTratamientoController::class, 'reportPagos'])->name('pagos.reportPagos');
        Route::get('reporte/{id}', [PagoTratamientoController::class, 'reportPagoDocto'])->name('pagos.reportPagoDocto');
    });

    // rutas mobiliario y equipo
    Route::resource('/mobiliario-y-equipo', 'MobiliarioEquipoController');
    Route::prefix('mobiliario')->group(function () {
        Route::get('/reporte', [MobiliarioEquipoController::class, 'reporte'])->name('mobiliario.reporte');
    });

    // rutas para insumos
    Route::resource('/insumos', 'InsumoController');
    Route::prefix('/insumo')->group(function () {

        Route::get('reportes', [InsumoController::class, 'reportPrints'])->name('insumos.reportPrints');
        Route::get('reporte', [InsumoController::class, 'reportPrint'])->name('insumos.reportPrint')->middleware('can:insumo_allreport');
        Route::get('/salidas', [InsumoController::class, 'salidas'])->name('insumos.salidas')->middleware('can:insumo_salidas');
        Route::post('/salidas/fechas', [InsumoController::class, 'salidasReporteDate'])->name('insumos.salidasReporteDate')->middleware('can:insumo_salidasreport');
        Route::delete('/salidas', [InsumoController::class, 'deleteSalida'])->name('insumos.deleteSalida')->middleware('can:insumo_salidaDelete');
        Route::delete('/lote/{lote}', [InsumoController::class, 'loteDestroy'])->name('insumos.loteDestroy');
        Route::post('/salidas', [InsumoController::class, 'salidaStore'])->name('insumos.salidaStore')->middleware('can:insumo_salidaStore');
    });

    // ruta pago facturas
    Route::resource('pago-facturas', 'PagoFacturaController');

    Route::get('pago/facturas', [PagoFacturaController::class, 'reporte'])->name('pago-facturas.reporte');


    // ruta para fotos
    Route::prefix('fotos')->group(function () {
        Route::get('', [FotoTratamientoController::class, 'index'])->name('fotos.index')->middleware('can:fotos_all');
        Route::get('/create', [FotoTratamientoController::class, 'create'])->name('fotos.create')->middleware('can:fotos_all');
        Route::post('', [FotoTratamientoController::class, 'store'])->name('fotos.store')->middleware('can:fotos_all');
        Route::put('', [FotoTratamientoController::class, 'update'])->name('fotos.update')->middleware('can:fotos_all');
        Route::delete('/delete/{id}', [FotoTratamientoController::class, 'delete'])->name('fotos.delete');

        Route::get('ver/{id}', [FotoTratamientoController::class, 'show'])->name('fotos.show')->middleware('can:fotos_all');
    });

    // laboratorios
    Route::prefix('laboratorio')->group(function () {
        Route::get('', [LaboratorioController::class,  'index'])->name('lab.index');
        Route::get('/perfil/{id}', [LaboratorioController::class,  'show'])->name('lab.show');
        Route::get('/create', [LaboratorioController::class,  'create'])->name('lab.create');
        Route::post('', [LaboratorioController::class,  'store'])->name('lab.store');
        Route::delete('/{id}', [LaboratorioController::class,  'destroy'])->name('lab.delete');
        Route::get('reporte', [LaboratorioController::class, 'reportes'])->name('lab.reportes');
        Route::get('reporte/all', [LaboratorioController::class, 'reporteAll'])->name('lab.reporteAll');
        Route::post('reporte/pacientes', [LaboratorioController::class, 'pacienteLaboratorio'])->name('lab.pacienteLaboratorio');
        Route::post('servicio', [LaboratorioController::class, 'storeServicio'])->name('lab.storeServicio');
        Route::delete('servicio/{id}', [LaboratorioController::class, 'deleteService'])->name('lab.deleteService');

        Route::get('reporte-deuda', [LaboratorioController::class, 'deudaLaboratorio'])->name('lab.deudaLaboratorio');
    });

    // deuda medicamento Controller
    Route::prefix('deuda/medicamento')->group(function () {
        Route::get('/{id}', [PacienteController::class, 'deudaMedicamentos'])->name('deuda.deudaMedicamentos');
        Route::post('', [PacienteController::class, 'storeDeudaMedicamento'])->name('deuda.storeDeudaMedicamento');
        Route::delete('/{id}', [PacienteController::class, 'deleteDeudaMedicamento'])->name('deuda.deleteDeudaMedicamento');
    });

    // recetas
    Route::prefix('recetas')->group(function () {
        Route::get('', [RecetaController::class,  'index'])->name('receta.index');
        Route::post('', [RecetaController::class,  'store'])->name('receta.store');
        Route::delete('/{id}', [RecetaController::class,  'destroy'])->name('receta.delete');
        Route::get('reporte', [RecetaController::class, 'reportes'])->name('receta.reportes');
        Route::get('/recetar', [RecetaController::class, 'recetar'])->name('receta.recetar');
        Route::post('/recetar', [RecetaController::class, 'recetarStore'])->name('receta.recetarStore');
        Route::get('/recetar/{fecha}', [RecetaController::class, 'printReceta'])->name('receta.printReceta');
        Route::get('/recetar/pos/{fecha}', [RecetaController::class, 'printRecetaDos'])->name('receta.printRecetaDos');
    });

    // bodegas kanaus
    Route::group(['prefix' => 'bodega-kanaus'], function () {
        Route::get('incio', [BodegaKanausController::class, 'index'])->name('bodegak.index');
        Route::get('show/{id}', [BodegaKanausController::class, 'show'])->name('bodegak.show');
        Route::get('create', [BodegaKanausController::class, 'create'])->name('bodegak.create');
        Route::get('reporte', [BodegaKanausController::class, 'reporte'])->name('bodegak.reporte');
        Route::post('store', [BodegaKanausController::class, 'store'])->name('bodegaK.store');
        Route::put('update/{id}', [BodegaKanausController::class, 'update'])->name('bodegak.update');
        Route::delete('delete/{id}', [BodegaKanausController::class, 'delete'])->name('bodegak.delete');
    });


    // COLORS kanaus
    Route::group(['prefix' => 'colores'], function () {
        Route::get('incio', [ColoresController::class, 'index'])->name('colork.index');
        Route::get('show/{id}', [ColoresController::class, 'show'])->name('colork.show');
        Route::get('reporte', [ColoresController::class, 'reporte'])->name('colork.reporte');
        Route::post('store', [ColoresController::class, 'store'])->name('colork.store');
        Route::put('update/{id}', [ColoresController::class, 'update'])->name('colork.update');
        Route::delete('delete/{id}', [ColoresController::class, 'delete'])->name('colork.delete');
    });

    // rutas articulos kanaus
    Route::group(['prefix' => 'articulos-kanaus'], function () {

        Route::get('inicio', [ArticuloKanausController::class, 'index'])->name('articuloK.index');
        ('can:articulok_listado');
        Route::get('articulok/{id}', [ArticuloKanausController::class, 'show'])->name('articuloK.show');
        Route::get('nuevo', [ArticuloKanausController::class, 'create'])->name('articuloK.nuevo');
        Route::post('store', [ArticuloKanausController::class, 'store'])->name('articuloK.store');
        Route::put('update/{id}', [ArticuloKanausController::class, 'update'])->name('articuloK.update');
        Route::get('delete/{id}', [ArticuloKanausController::class, 'destroy'])->name('articuloK.delete');
        Route::get('control/stock', [ArticuloKanausController::class, 'controlStock'])->name('articuloK.stock');

        // reportes
        Route::get('reportes', [ArticuloKanausController::class, 'reportes'])->name('articuloK.repotes');
        Route::get('reportes/all', [ArticuloKanausController::class, 'reportAll'])->name('articuloK.repotesAll');
        Route::get('reportes/allmin', [ArticuloKanausController::class, 'reportAllmin'])->name('articuloK.repotesAllmin');
        Route::get('reportes/control/stock', [ArticuloKanausController::class, 'stockControl'])->name('articuloK.stockControl');
        Route::get('reportes/control/stock/salidas', [ArticuloKanausController::class, 'articulosvendidos'])->name('articuloK.articulosvendidos');

        // Export Data
        Route::get('articulo/data/{id}', [ArticuloKanausController::class, 'dataPrint'])->name('articuloK.exportdata');
    });

    // rutas  ventas kanaus
    Route::group(['prefix' => 'ventas-kanaus'], function () {
        Route::get('index', [VentaKanausController::class, 'index'])->name('ventaK.index');

        Route::post('store', [VentaKanausController::class, 'store'])->name('ventaK.store');

        Route::get('pagar/credito/{id}', [VentaKanausController::class, 'pagarCredito'])->name('ventaK.pagar');
        Route::get('factura/print/{idFactura}', [VentaKanausController::class, 'ventaPrint'])->name('ventaK.facturaPrint');
        Route::get('historial/ventaKs', [VentaKanausController::class, 'historial'])->name('ventaK.historial');
        Route::get('anular/{id}/{idArt}', [VentaKanausController::class, 'destroy'])->name('ventaK.delete');

        // reportes
        Route::get('reportes', [VentaKanausController::class, 'reportes'])->name('ventaK.reportes');
        Route::get('reportes/ventas', [VentaKanausController::class, 'reportesVentasAll'])->name('ventaK.reportesAll');
        Route::get('reportes/ventas/contado', [VentaKanausController::class, 'reportesVentasContado'])->name('ventaK.reportesAlContado');
        Route::get('reportes/ventas/crediro', [VentaKanausController::class, 'reportesVentasCredito'])->name('ventaK.reportesAlCrediro');
        Route::get('reporte/dia', [VentaKanausController::class, 'ventasDia'])->name('ventaK.diaReport');
        Route::get('reporte/movimientos', [VentaKanausController::class, 'movimientos'])->name('ventaK.movimientos');
        Route::get('estadistica', [VentaKanausController::class, 'estadistica'])->name('ventaK.estadistica');
    });

    // rutas para las graficas estadisticas
    Route::prefix('graficas')->group(function () {
        Route::get('tratamientos', [GraficaController::class, 'tratamientos'])->name('graficas.tratamientos');
        Route::get('insumos', [GraficaController::class, 'insumos'])->name('graficas.insumos');
        Route::get('caja', [GraficaController::class, 'caja'])->name('graficas.caja');
    });

    // ruta descuento doctor
    Route::prefix('descuento-doctor')->group(function () {
        Route::get('inicio/{id}', [DescuentoDoctorController::class, 'index'])->name('des.index');
        Route::post('store/', [DescuentoDoctorController::class, 'store'])->name('des.store');
        Route::delete('delete/{id}', [DescuentoDoctorController::class, 'delete'])->name('des.delete');
    });

    Route::prefix('escaner')->group(function () {
        Route::get('index/{id}', [EscanerController::class, 'index'])->name('escan.dpi');
        Route::post('store', [EscanerController::class, 'store'])->name('escan.store');
    });

    // recodatorio general
    Route::prefix('recordatio-general')->group(function () {
        Route::get('index', [RecordatorioGeneralController::class, 'index'])->name('reco.index');
        Route::get('registro', [RecordatorioGeneralController::class, 'create'])->name('reco.create');
        Route::get('edit/{id}', [RecordatorioGeneralController::class, 'edit'])->name('reco.edit');
        Route::post('store', [RecordatorioGeneralController::class, 'store'])->name('reco.store');
        Route::put('update/{id}', [RecordatorioGeneralController::class, 'update'])->name('reco.update');
        Route::delete('delete/{id}', [RecordatorioGeneralController::class, 'destroy'])->name('reco.delete');
    });

    // rutas para consentimientos
    Route::prefix('consentimientos')->group(function () {
        Route::get('informados/{id}', [ConsentimientosController::class, 'consentimientos_infromados'])->name('cons.consentimientos_infromados');
        Route::get('anestesia/{id}', [ConsentimientosController::class, 'consentimientos_anestesia'])->name('cons.consentimientos_anestesia');
        Route::get('protesis/{id}', [ConsentimientosController::class, 'consentimientos_protesis'])->name('cons.consentimientos_protesis');
        Route::get('endodoncia/{id}', [ConsentimientosController::class, 'consentimientos_endodoncia'])->name('cons.consentimientos_endodoncia');
        Route::get('extraccion/{id}', [ConsentimientosController::class, 'consentimientos_extraccion'])->name('cons.consentimientos_extraccion');
    });

    // Protesis
    Route::group(['prefix' => 'protesis'], function () {
        Route::get('removibles', [ProtecisController::class, 'removibles'])->name('pro.removibles');
        Route::get('removibles/save', [ProtecisController::class, 'removibleSave'])->name('pro.removibleSave');
        Route::post('removibles/new', [ProtecisController::class, 'removibleNew'])->name('pro.removibleSaveNew');
        Route::get('total', [ProtecisController::class, 'proTotal'])->name('pro.total');
        Route::get('total/save', [ProtecisController::class, 'totalSave'])->name('pro.totalSave');
        Route::post('total/new/save', [ProtecisController::class, 'totalNewSave'])->name('pro.totalNewSave');
        Route::get('fija', [ProtecisController::class, 'fijas'])->name('pro.fijas');
        Route::get('fija/save', [ProtecisController::class, 'fijaSave'])->name('pro.fijaSave');
        Route::post('fija/new', [ProtecisController::class, 'fijasSaveNew'])->name('pro.fijaSaveNew');
        Route::get('detalles', [ProtecisController::class, 'protesisDetail'])->name('pro.details');
        Route::get('detalles/save', [ProtecisController::class, 'protesisSave'])->name('pro.detailSave');
        Route::post('endo/new', [ProtecisController::class, 'endoSaveNew'])->name('pro.endoSaveNew');
        Route::get('historial/save', [ProtecisController::class, 'histrataSave'])->name('pro.historialSave');
    });


    Route::group(['ortodoncia' => 'protesis'], function () {
        Route::get('index', [OrtodonciaController::class, 'index'])->name('orto.index');
        Route::post('post', [OrtodonciaController::class, 'store'])->name('orto.store');
        Route::get('reportes', [OrtodonciaController::class, 'reportes'])->name('orto.reportes');
        Route::POST('pacietes_ortodoncia', [OrtodonciaController::class, 'paciente_orto_fecha'])->name('orto.paciente_orto_fecha');
        Route::POST('doctor_ortodoncia', [OrtodonciaController::class, 'doc_orto_fecha'])->name('orto.doc_orto_fecha');
        Route::delete('delete/{id}', [OrtodonciaController::class, 'delete'])->name('orto.delete');
        Route::get('recibo/{id}', [OrtodonciaController::class, 'print_reciboo'])->name('orto.print_reciboo');

        Route::POST('descuento-orto', [OrtodonciaController::class, 'decuento_Orto'])->name('orto.decuento_Orto');
    });
});



// =============================================
// =============================================
// ==== para gestionar agenda=======
// =============================================
// =============================================
Route::get('admin/agenda', [AgendaController::class, 'index'])->name('agenda.index');
Route::post('admin/nota-create-agenda', [AgendaController::class, 'createNota'])->name('agenda.createNota');
Route::delete('admin/agenda-delete/{nota}', [AgendaController::class, 'deleteNota'])->name('agenda.deleteNota');
Route::get('admin/agenda/listar', [AgendaController::class, 'getEvents'])->name('agenda.getEvents');
Route::post('admin/agenda/guardar', [AgendaController::class, 'store'])->name('agenda.store');
Route::put('admin/agenda/actualizar/{id}', [AgendaController::class, 'update'])->name('agenda.update');
Route::delete('admin/agenda/borrar/{id}', [AgendaController::class, 'destroy'])->name('agenda.destroy');
    // =============================================
    // =============================================
