<?php

use App\Http\Controllers\Admin\DiarioController;
use App\Http\Controllers\Doctor\AuthDoctorController;
use App\Http\Controllers\Doctor\PacienteDoctorController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => "doctor",  'namespace' => 'App\Http\Controllers\Doctor', 'middleware' => []], function () {

    Route::get('login', [AuthDoctorController::class, 'login_index'])->name('login_doctor');
    Route::post('login', [AuthDoctorController::class, 'login'])->name('doc.login');
    Route::post('logout', [AuthDoctorController::class, 'logout'])->name('doctor.logout');

    Route::get('home', [AuthDoctorController::class, 'home'])->name('doc.home');
    Route::get('doc/pacientes/ajax', [AuthDoctorController::class, 'getPacientesAjax'])->name('doc.pacientes.ajax');

    Route::get('reoporte', [AuthDoctorController::class, 'reportes'])->name('doc.reportes');

    Route::get('pacientesHoy', [AuthDoctorController::class, 'pacientesHoy'])->name('doc.pacientesHoy');
    Route::get('actualizar-procedimiento/{id}', [AuthDoctorController::class, 'updateProcedimiento'])->name('doctor.updateProcedimiento');
    Route::get('actualizar-procedimiento-ajax', [AuthDoctorController::class, 'updateProcedimientoajax'])->name('doctor.updateProcedimientoajax');



    Route::get('reporte/{id}', [AuthDoctorController::class, 'reportPagoDocto'])->name('doc.reportPagoDocto');
    Route::get('/reporte/pagos/{id}', [AuthDoctorController::class, 'prindPagos'])->name('doc.prindPagos');


    Route::group(['prefix' => 'paciente'], function () {
        Route::get('show/{paciente}', [PacienteDoctorController::class, 'showPaciente'])->name('doc.paciente-showPaciente');
        Route::post('store-pago', [PacienteDoctorController::class, 'setPagosHistorialAndMore'])->name('doc.paciente-setPagosHistorialAndMore');
    });



    Route::post('diario-store', [DiarioController::class, 'store'])->name('doc.diario-store');
});
