@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col  ">
            <div align="center">
                <img src="{{asset('assets/images/logo.jpg')}}" class="img-fluid rounded-circle mt-4" width="20%" height="350px" alt="">
                <p class="text-decoration-none"></p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col mt-4">
            <h4 class="display-4 text-capitalize text-center"> Articulos Vendidos del mes: {{$mes}}, del año : {{$ano}} </h4>
        </div>
    </div>
    <div class="row my-4">
        <div class="col">
            <table class="table table-hover" id="deudas" data-page-length="15">
                <thead>
                    <tr>
                        <th>No. Factura</th>
                        <th>Articulo </th>
                        <th>Precio Venta</th>
                        <th>Precio Costo</th>
                        <th>Utilidad / Unitaria</th>
                        <th>Cantidad Vendida</th>
                        <th>Descuento</th>
                        <th>Total Con Descuento</th>
                        <th>Ganancia</th>
                        <th>Fecha / Hora de Venta</th>

                    </tr>
                </thead>
                <tbody>
                    <?php

                    $utilidad = 0;
                    $descuentos = 0;
                    $totalVentasS = 0;

                    ?>
                    @foreach($ventas as $deu)
                    <?php
                    $totalVentasS = ($deu->p_venta *  $deu->cantidad) + $totalVentasS;
                    ?>
                    <tr>
                        <td>{{$deu->factura_id}}</td>
                        <td>{{$deu->nomArt}} / {{$deu->descripcion}}</td>
                        <td>{{$deu->p_venta}}</td>
                        <td>{{$deu->p_costo}}</td>
                        <td>{{$deu->p_venta - $deu->p_costo}}</td>
                        <td>{{$deu->cantidad}}</td>
                        <td>
                            <?php
                            $descuentos = $deu->descuento + $descuentos;
                            ?>
                            {{$deu->descuento}}
                        </td>


                        <td>{{($deu->p_venta ) * $deu->cantidad - ($deu->descuento)}}</td>

                        <?php



                        $utilidad = (($deu->p_venta * $deu->cantidad) - ($deu->p_costo * $deu->cantidad)) - $deu->descuento + $utilidad;

                        ?>

                        <td>{{ (($deu->p_venta * $deu->cantidad ) - ($deu->p_costo * $deu->cantidad)) - $deu->descuento}} </td>

                        <td>{{$deu->fechaVenta}}</td>

                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>

    <div class="row" style="text-align: right;">
        <div class="col">

            <h3 class="text-right text-info">
                <p>Total en Ventas (esperadas) :</p> Q. {{ $totalVentasS }}
                <p>Total en Ventas - Descuentos :</p> Q. {{ $totalVentasS -  $descuentos }}
                <p>Total en Descuentos :</p> Q. {{ $descuentos      }}
                <p>Ganancias :</p> Q. {{number_format($utilidad, 2)}}

            </h3>

        </div>
    </div>
    <hr>

</div>

@endsection


