@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col  ">
            <div align="center">
                <img src="{{asset('assets/images/logo.png')}}" class="img-fluid  mt-4" style="width: 20%;" alt="">
                <p class="text-decoration-none"></p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col mt-4">
            <h4 class="display-4 text-capitalize text-center"> Artículos Vendidos El <?php echo date('d-m-Y'); ?></h4>
        </div>
    </div>
    <div class="row my-4">
        <div class="col">
            <table class="table table-hover" id="table_id">
                <thead>
                    <tr>
                        <th>No. Factura</th>
                        <th>Artículo </th>
                        <th>Precio Venta</th>
                        <th>Precio Costo</th>
                        <th>Utilidad / Unitaria</th>
                        <th>Cantidad Vendida</th>
                        <th>Descuento</th>
                        <th>Total Con Descuento</th>
                        <th>Ganancia</th>
                        <th>Fecha / Hora de Venta</th>

                    </tr>
                </thead>
                <tbody>
                    <?php

                    $utilidad = 0;
                    $descuentos = 0;
                    $totalVentasS = 0;

                    ?>
                    @foreach($ventas as $deu)
                    <?php
                    $totalVentasS = ($deu->p_venta *  $deu->cantidad) + $totalVentasS;
                    ?>
                    <tr>
                        <td>{{$deu->factura_id}}</td>
                        <td>{{$deu->nomArt}} / {{$deu->descripcion}}</td>
                        <td>{{$deu->p_venta}}</td>
                        <td>{{$deu->p_costo}}</td>
                        <td>{{$deu->p_venta - $deu->p_costo}}</td>
                        <td>{{$deu->cantidad}}</td>
                        <td>
                            <?php
                            $descuentos = $deu->descuento + $descuentos;
                            ?>
                            {{$deu->descuento}}
                        </td>


                        <td>{{($deu->p_venta ) * $deu->cantidad - ($deu->descuento)}}</td>

                        <?php

                        $utilidad = (($deu->p_venta * $deu->cantidad) - ($deu->p_costo * $deu->cantidad)) - $deu->descuento + $utilidad;

                        ?>

                        <td>{{ (($deu->p_venta * $deu->cantidad ) - ($deu->p_costo * $deu->cantidad)) - $deu->descuento}} </td>

                        <td>{{$deu->fechaVenta}}</td>

                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>

    <div class="row" style="text-align: right;">
        <div class="col">

            <h3 class="text-info">
                <p>Total en Ventas (esperadas) :</p> Q. {{ $totalVentasS }}
                <p>Total en Ventas - Descuentos :</p> Q. {{ $totalVentasS -  $descuentos }}
                <p>Total en Descuentos :</p> Q. {{ $descuentos      }}
                <p>Ganancias :</p> Q. {{$utilidad}}

            </h3>

        </div>
    </div>
    <hr>


</div>


@endsection

@section('scripts')

<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>
@endsection