@extends('layouts.app')

@section('content')


<div class="container-fluid">

   <div class="row">
      <div class="col">
         <p class="text-center h3 text-uppercase">Check List {{$user->name}}</p>
      </div>
   </div>

   <div class="row">
      <div class="col">

         <table class="table">
            <thead>
               <tr>
                  <th>Actividad</th>
                  <th>Estado</th>
                  <th>Fecha</th>
               </tr>
            </thead>
            <tbody>
               @foreach ($lists as $list )
               <tr>
                  <td scope="row">
                     {{$list->nombre}}
                  </td>
                  <td scope="row">
                     @if ($list->estado === 'no' || $list->estado === 'NO')
                     <span class="badge badge-danger"> {{$list->estado}}</span>
                     @else
                     <span class="badge badge-primary"> {{$list->estado}}</span>
                     @endif
                  </td>
                  <td scope="row">
                     {{$list->created_at}}
                  </td>
               </tr>
               @endforeach
            </tbody>
         </table>

      </div>
   </div>
</div>


@endsection