@extends('layouts.app')

@section('content')


<div class="container-fluid">

   <div class="row">
      <div class="col">
         <p class="text-center h3 text-uppercase">{{$user->name}}</p>
      </div>
   </div>

   <div class="row">



      @foreach ($lists as $list )
      <div class="col-md-3 col-xl-2">
         <div class="card user-card p-4">
            <div class="card-header-img">
               <img class="img-fluid img-radius" src="">
               <h4 class="text-center text-uppercase">{{$list->nombre}}</h4>
            </div>


            <div>
               @can('usuario_cabiarCheck')
               <a href="{{route('users.cabiarCheck', ['id' => $list->id])}}" class="btn btn-info waves-effect waves-light m-r-15">
                  @if ($list->estado === 'no' || $list->estado === 'NO')
                  <i class="fa fa-check" aria-hidden="true"></i>
                  @else
                  <i class="fa fa-window-close" aria-hidden="true"></i>
                  @endif
               </a>
               @endcan
            </div>
         </div>
      </div>
      @endforeach



   </div>
</div>


@endsection