@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col">

            <button class="btn btn-info" onclick="exportarExcel()">EXPORTAR TABLA EXCEL </button>
            <table class="table" id="table_id" data-page-length="15">
                <thead class="">
                    <tr>
                        <th>Paciente</th>
                        <th>Tratamiento</th>
                        <th>Valor</th>
                        <th>Doctor</th>
                        <th>Abonos Del Dia</th>
                        <th>Fecha</th>
                        <th>Ultima Fecha de Visita</th>


                    </tr>
                </thead>
                <tbody>
                    <?php
                    $total = 0;
                    ?>
                    @foreach ($data as $tr)
                    <tr>
                        <?php
                        $nombre = 'ANULADO';
                        $f = 'PACIENTE ANULADO';
                        $id = 0;
                        $doc = '';

                        if (isset($tr->paciente->nombre)) {
                            $nombre = $tr->paciente->nombre;
                            $id = $tr->paciente->id;
                            $f = $tr->paciente->updated_at;
                            $id = $tr->paciente_id;
                            $doc = getUltimoDoctor($id)->doctor->nombre ?? 'Dr. Anulado';
                        }

                        $total += $tr->valor;



                        ?>
                        <td>
                            {{ $nombre }}

                            @if ($id != 0)
                            <a target="_blank" class="btn btn-dark" href="{{ route('abono.abonar', ['paciente' => $nombre, 'id' => $id]) }}"><i class="fa fa-print" aria-hidden="true"></i></a>
                            @endif <br>
                            Doc. {{ $doc }}
                        </td>
                        <td>{{ $tr->tratamiento->nombre ?? 'TRATAMIENTO ANULADO' }}, {{ $tr->tratamiento->descripcion ?? 'TRATAMIENTO ANULADO' }},
                            {{ $tr->tratamiento->tipo ?? 'TRATAMIENTO ANULADO' }}
                        </td>
                        <td>Q. {{ number_format($tr->valor, 2) }}</td>
                        <td>{{ $tr->doctor?->nombre }}</td>
                        <td>

                            <!--  hacer que los abonos sean de acada tratamiento  -->
                            @foreach (getAbonosToDia($tr->updated_at, $id) as $ab)
                            <!-- {{ $ab->descripcion }} - Q. {{ number_format($ab->valor, 2) }} <br> -->
                            @endforeach
                            <?php
                            $abs = getAbonoToTratamiento($tr->updated_at, $id, $tr->tratamiento_id);
                            ?>
                            <hr>

                            {{ $abs->descripcion ?? '' }} - Q. {{ number_format($abs->valor ?? 0, 2) }}

                        </td>
                        <td>{{ $tr->updated_at }}</td>
                        <td>{{ $f }}</td>
                    </tr>
                    @endforeach
                    <p class="h3">TOTAL: Q. {{ number_format($total, 2) }}</p>
                </tbody>
            </table>




        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.2/xlsx.full.min.js"></script>

<script>
    function exportarExcel() {
        var tabla = document.getElementById('table_id');
        var wb = XLSX.utils.table_to_book(tabla, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, "Total Tratamientos.xlsx");
    }
</script>

@endsection