@extends('layouts.app')


@section('styles')
<style>
    #filter-row th {
        padding: 5px;
        background-color: #f8f9fa;
        border-top: none !important;
    }

    .fila-maxilo {
        background-color: #fff3cd !important;
    }

    .dataTables_length {
        margin-bottom: 15px;
        margin-right: 15px;
        display: inline-block;
    }

    .dt-buttons {
        margin-bottom: 15px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col">

            <!-- <button class="btn btn-info" onclick="exportarExcel()">EXPORTAR TABLA EXCEL </button> -->
            <table class="table" id="table_id" data-page-length="25">
                <thead class="">
                    <tr>
                        <th>PACIENTE</th>
                        <th>TRATAMIENTO</th>
                        <th>DOCTOR</th>
                        <th>FECHA</th>
                        <th>ASISTENTE</th>
                    </tr>
                    <tr id="filter-row">
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th id="asistente-filter"></th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($data as $item)
                    <tr>
                        <td>
                            {{-- Datos del paciente (ya cargados con Eager Loading) --}}
                            {{ $item->paciente->nombre }} <br>

                            @if ($item->tratamiento->tipo3 == 'NO')
                            <span class="badge badge-warning">NO APLICA SALIDAS</span>
                            @endif

                            @if ($item->tratamiento->tipo3 == 'SI')

                            {{-- AHORA: Verificamos la propiedad que creamos en la subconsulta (salidainsumos)--}}
                            {{-- Si es 1 (true), entra. Si es null (false), se va al else. --}}
                            @if ($item->tiene_salida)
                            <span class="badge badge-info">SI REALIZADO</span>
                            @else
                            <span class="badge badge-danger">NO REALIZADO</span>

                            {{-- Botón de desbloqueo --}}
                            <a href="{{ route('tratamientos.desbloquear', $item->id) }}" class="btn btn-success">
                                <i class="fa fa-unlock" aria-hidden="true"></i>
                            </a>
                            @endif

                            @endif
                        </td>
                        <td>{{$item->tratamiento->nombre ?? 'Tr. Eliminado'}} - {{$item->tratamiento->descripcion ?? ''}}</td>
                        <td>{{$item->doctor->nombre ?? 'Doctor Eliminado'}}</td>
                        <td>{{$item->fecha}}</td>
                        <td>{{$item->asistio}}</td>

                    </tr>
                    @endforeach

                </tbody>
            </table>




        </div>
    </div>
</div>
@endsection

@section('scripts')


<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>


<script>
    var ruta = " {{ route('pacientes.getAjaxPaciente') }}";


    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'lBfrtip',
            processing: true,


            // Personalizamos las opciones del select
            lengthMenu: [
                [10, 25, 50, 100, -1], // Valores lógicos (-1 es "Todos")
                [10, 25, 50, 100, "Todos"] // Etiquetas que ve el usuario
            ],

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

            // --- FILTRO DINÁMICO ---
            initComplete: function() {
                // Buscamos la columna 4 (ASISTENTE)
                this.api().columns(4).every(function() {
                    var column = this;

                    // Creamos el select y lo añadimos al TH correspondiente
                    var select = $('<select class="form-control form-control-sm"><option value="">Todos</option></select>')
                        .appendTo($('#asistente-filter').empty())
                        .on('change', function() {
                            var val = $.fn.dataTable.util.escapeRegex($(this).val());
                            // Aplicamos el filtro: si es exacto usamos ^val$
                            column.search(val ? '^' + val + '$' : '', true, false).draw();
                        });

                    // Extraemos los datos únicos de la columna para llenar el select
                    column.data().unique().sort().each(function(d, j) {
                        // Limpiamos el HTML por si el nombre viene con etiquetas
                        var text = $(d).text().trim() || d;
                        select.append('<option value="' + text + '">' + text + '</option>');
                    });
                });
            },


            // --- AQUÍ ESTÁ EL CAMBIO ---
            createdRow: function(row, data, dataIndex) {
                // Evaluamos si la columna 'tipo' es igual a 'maxilo'
                if (data.aut9 === 'maxilo') {
                    // Opción A: Agregar una clase CSS (Recomendado)
                    $(row).addClass('fila-maxilo');

                    // Opción B: Cambiar estilos directamente (No recomendado pero funciona rápido)
                    // $(row).css('background-color', '#ffcccc');
                }
            },


        });




    });
</script>


@endsection