@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <p class="display-4 text-center">{{$titulo}}</p>
            <table class="table" id="table_id" data-page-length="15">
                <thead class="">
                    <tr>
                        <th>#</th>
                        <th>Tratamiento</th>
                        <th>Precio Publico</th>
                        <th>Tipo </th>
                        <th>Doctor</th>
                        <th>Porcentaje</th>
                        <th>Pago</th>
                        @if ($visible)

                        <th>Ganancia Clínica</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @foreach ($pagos as $pago)

                    @php
                    $gananciaClinica = 0;
                    $pagoDoctor= 0;
                    @endphp

                    <tr>
                        <td>{{ $pago->id }}</td>
                        <td>{{ $pago->tratamiento }}</td>
                        <td> Q. {{ number_format($pago->precio,2)}} </td>
                        <td>{{ $pago->tipo }}</td>
                        <td>{{ $pago->doctor }}</td>
                        <td>{{ $pago->porcentaje }} %</td>

                        @php
                        $pagoDoctor = ($pago->precio * $pago->porcentaje) / 100;
                        $gananciaClinica = $pago->precio - $pagoDoctor;
                        @endphp

                        <td>Q. {{ number_format($pagoDoctor,2) }}</td>
                        @if ($visible)
                        <td>Q. {{ number_format($gananciaClinica,2) }}</td>
                        @endif
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
</div>

@endsection