@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <table class="table" id="table_id" data-page-length="15">
                <thead class="">
                    <tr>
                        <th>Nombre</th>
                        <th>Descripción</th>
                        <th>Tipo</th>
                        <th>Cantidad</th>


                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $tratamiento)
                    <tr>
                        <td>{{ $tratamiento->nombre }}</td>
                        <td>{{ $tratamiento->descripcion }}</td>
                        <td>{{ $tratamiento->tipo }}</td>
                        <td>{{ $tratamiento->trid }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>


            <button class="btn btn-info" onclick="exportarExcel()">EXPORTAR TABLA EXCEL </button>


        </div>
    </div>
</div>

@endsection


@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.2/xlsx.full.min.js"></script>

<script>
    function exportarExcel() {
        var tabla = document.getElementById('table_id');
        var wb = XLSX.utils.table_to_book(tabla, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, "Mas a Menos.xlsx");
    }
</script>
@endsection