@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <button class="btn btn-info" onclick="exportarExcel()">EXPORTAR TABLA</button>

            @foreach ($data as $d)
            <p class="h2 text-center">{{$d->tratamiento->nombre}} - {{$d->tratamiento->descripcion}} </p>



            <table class="table" id="table_id" data-page-length="15">
                <thead class="">
                    <tr>
                        <th>Paciente</th>
                        <th>Teléfono</th>
                        <th></th>
                        <th>Ultima Fecha de Visita</th>

                    </tr>
                </thead>
                <tbody>
                    @foreach (pacientesPendientes($d->tratamiento_id, $inicio, $fin) as $d1)
                    <tr>

                        <td>
                            <?php
                            $n = 'ANULADO';
                            $t = '0000 - 0000';
                            $f = 'PACIENTE ELIMINADO';
                            $id = 0;

                            if (isset($d1->paciente->nombre)) {
                                $n = $d1->paciente->nombre;
                                $t = $d1->paciente->telefono;
                                $f = $d1->created_at;
                                $id = $d1->paciente_id;
                            }
                            echo  $n . ' <br> Doc.' . getUltimoDoctor($id)->doctor->nombre ?? 'Dr. Anulado';
                            ?>
                        </td>
                        <td>{{ $t }}</td>

                        <td>
                            <a class="btn btn-sm btn-primary " href="{{ route('pacientes.show',$d1->paciente_id) }}"><i class="fa fa-fw fa-eye"></i> </a>
                        </td>
                        <td>{{$f}} </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @endforeach

        </div>
    </div>
</div>

@endsection



@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.2/xlsx.full.min.js"></script>

<script>
    function exportarExcel() {
        var tabla = document.getElementById('table_id');
        var wb = XLSX.utils.table_to_book(tabla, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, "Faltantes Tratamientos.xlsx");
    }
</script>

@endsection