<!DOCTYPE html>
<html>

<head>
   <link rel="stylesheet" href="style.css">
   <title>{{config('app.name')}}</title>
   <!-- <link rel="shortcut icon" href="{{asset('assets/images/logo.ico')}}" type="image/x-icon"> -->
   <link rel="shortcut icon" href="{{asset('assets/images/logo.ico')}}" type="image/x-icon">
   <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Sarina">
   <script src="{{asset('plugins/fontaweson/fontaws.js')}}"></script>

</head>

<style>
   @media print {

      .oculto-impresion,
      .oculto-impresion * {
         display: none !important;
      }
   }

   * {
      font-size: 12px;
      font-family: system-ui;
      font-weight: 500;
   }

   /* .titulo {
      font-family: 'Sarina', serif;
      text-transform: capitalize;
   } */

   td,
   th,
   tr,
   table {
      border-top: 1px solid black;
      border-collapse: collapse;
   }

   td.producto,
   th.producto {
      width: 165px;
      max-width: 165px;
   }

   td.cantidad,
   th.cantidad {
      width: 40px;
      max-width: 40px;
      word-break: break-all;
   }

   td.precio,
   th.precio {
      width: 50px;
      max-width: 50px;
      word-break: break-all;
   }

   .centrado {
      text-align: center;
      align-content: center;
   }

   .ticket {
      width: 285px;
      max-width: 357px;
   }

   img {
      max-width: inherit;
      width: inherit;
   }
</style>

<body align="center">
   <div class="ticket">
      <div class="row">

         <p style="text-align: center; font-size: 2rem; text-transform: capitalize;" class="titulo">
            <i class="fas fa-tooth    " style="font-size: 1.8rem;"></i>

            {{config('app.name')}}

            <i class="fas fa-tooth    " style="font-size: 1.8rem;"></i>
         </p>
         <div class="col-8">



            <div align="center">
               <div style="font-size: 20px;">
                  <p class="text-uppercase text-center">
                     {{config('app.direccion')}}
                  </p>
                  <p class="text-center">
                     TELEFONO: <span class="text-info">{{config('app.telefono')}}</span>
                  </p>
               </div>
            </div>

            <div align="center">
               <div class="text-right" style="font-size: 20px;">
                  <p class="text-uppercase text-center">
                     <b class="text-danger">RECETA MEDICA</b><br>
                     FECHA: {{$fecha}} <br>
                  </p>
               </div>
            </div>
         </div>

      </div>



      <div align="center">
         <p>NOMBRE: {{$paciente}} <span class="text-rigth"> <br> </span> </p>


      </div>


      <div align="center" style="border: 1px solid black; padding: 5px;">
         <div class="text-right" style="font-size: 20px;">
            <p class="text-uppercase text-center">
               @foreach ($recetas as $receta)

               @php
               echo $receta->recetaNombre;
               @endphp

               @endforeach
            </p>
         </div>
      </div>


      <p class="centrado">
         {{config('app.slogan')}}
         <br>{{config('app.name') }}
      </p>


   </div>

   <button class="oculto-impresion" onclick="imprimir()">Imprimir</button>


   <script>
      function imprimir() {
         window.print();
      }
   </script>

</body>

</html>