<!DOCTYPE html>
<html dir="ltr" lang="es">

<head>

    <title>{{config('app.name')}}</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="Sobre Nosotros">
    <meta name="keywords" content="Dientes, Dentista, Boca, Clinica, Quetzaltenango, clinica Quetzaltenango, Xela, clinica">
    <meta name="author" content="DeCoDev Desarrollo de Software">
    <link rel="icon" href="{{asset('logos/ico.ico')}}" type="image/x-icon">

    <link rel="stylesheet" href="{{asset('plugins/bootstrap/bootstrap.min.css')}}">

    <script src="{{asset('plugins/fontaweson/fontaws.js')}}"></script>

    <link rel="stylesheet" href="{{asset('styles.css')}}">
    <link href="https://fonts.googleapis.com/css2?family=Shippori+Antique&display=swap" rel="stylesheet">

    <style>
        @media print {

            .oculto-impresion,
            .oculto-impresion * {
                display: none !important;
            }



            h5 {
                font-size: 10px;
                padding: 5px;
            }
        }



        body {

            font-family: 'Shippori Antique', sans-serif;
            /* font-weight: lighter; */
            /* text-transform: uppercase; */
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }


        .borders {
            border: 1px solid black;
            margin-bottom: 1%;
        }

        .wenas {
            margin-bottom: 2%;
        }

        .txt-lineal {
            border-top: 0;
            border-left: 0;
            border-right: 0;
            border-bottom: 1px solid;
        }

        input {
            font-size: 16px;
            text-transform: uppercase;
            text-align: center;
        }

        .titulo123 {
            background: black;
            color: white;
        }

        .titulon {
            background: #002659;
            color: white;
        }


        @media print {


            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;

                margin: 0;
                padding: 0;

            }

            @page {
                margin: 0;

            }

            .contenedor {
                font-size: 20px;
            }

            .texto1 {
                font-size: 24px;
            }

            .salto {
                page-break-after: always;
            }

            .borders {
                padding-bottom: 42%;
            }

            input {
                font-size: 20px;
                text-transform: uppercase;
                text-align: center;
            }



        }
    </style>
</head>

<body style="background: white;" style="text-transform: uppercase;">

    <div class="row oculto-impresion">
        <div class="col">
            <div class="form-group">
                <label for="">RECETA DE</label>
                <select class="form-control" id="receta">
                    <option>Selecciones Tipo</option>
                    <option value="nery">NERY GONZALEZ</option>
                    <option value="clinica">CLINICA SONRIEME</option>
                </select>
            </div>
        </div>
    </div>




    <div class="row justify-content-center  py-3 titulo123" id="clinica">
        <div class="col-md-5 text-center">
            <img class="rounded shadow-sm" style="width: 25%;" src="{{asset('logos/icono.jpg')}}" alt="{{config('app.name')}}">
        </div>
        <div class="col-md-5 text-center">
            <p>
                <b>CLINICA ODONTOLOGICA</b> <br>
                {{config('app.direccion')}} <br>
                Tel. {{config('app.telefono')}} Email: {{config('app.email')}}
            </p>
        </div>
    </div>


    <div class="row justify-content-center  py-3 titulon" id="nery">
        <div class="col-md-5 text-center">
            <img class="rounded shadow-sm" style="width: 45%;" src="{{asset('logos/nery.png')}}" alt="{{config('app.name')}}">
        </div>
        <div class="col-md-5 text-center">
            <p>
                <b>Cirugía Maxilofacial Estética y Reconstructiva</b> <br>
                {{config('app.direccion')}} <br>
                Tel. +502 5497 4881 <br> Email: dr.nerygonzalezmolina@gmail.com
            </p>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="contenedor">
                    <div class="row">
                        <div class="col">
                            <h1 class="text-center" style="color:rgb(0, 0, 0)"> RECETA </h1>


                            <div class="mt-3 mb-3">
                                PACIENTE: <input type="text" class="linea" style="width: 60%; text-transform: uppercase;text-align: center;" value="{{$paciente}}" name="dpi">
                                FECHA: <input type="text" name="direccion" class="linea" style="width: 20%; text-transform: uppercase;text-align: center;" value="{{$fecha}}" required>
                                <br>
                            </div>

                            <div class="borders py-4 pl-2 ">
                                RP.
                                <div style="margin-left: 3%;">
                                    @foreach ($recetas as $rece)
                                    <?php echo $rece->recetaNombre; ?>
                                    @endforeach
                                </div>
                            </div>

                            <div class="wenas">
                                Su Proxima cita es: <input type="text" class="linea" style="width: 73%; text-transform: uppercase; text-align: center;" name="nombre" required>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <script src="{{asset('plugins/bootstrap/jquery.min.js')}}"></script>
    <script src="{{asset('plugins/bootstrap/popper.min.js')}}"></script>
    <script src="{{asset('plugins/bootstrap/bootstrap.min.js')}}"></script>


    <script>
        $(document).ready(function() {
            $('#receta').on('change', function() {
                if (this.value == 'clinica') {
                    $('#clinica').show();
                    $('#nery').hide();
                } else if (this.value == 'nery') {
                    $('#nery').show();
                    $('#clinica').hide();
                } else {
                    $('#nery').hide();
                    $('#clinica').hide();
                }
            });
        });
    </script>

</body>

</html>