@extends('layouts.app')

@section('content')

<div class="container-fluid px-5">

    <div class="row">
        <div class="col">
            <p class="text-center text-uppercase h1">RECORDATORIO DE: {{$paciente->nombre}} <button type="button" class="btn btn-primary btn-lg oculto-impresion" data-toggle="modal" data-target="#diario">
                    NUEVO RECORDATORIO
                </button></p>


            <table class="table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>DESCRIPCIÓN</th>
                        <th>DIAS ANTES</th>
                        <th>FECHA</th>
                        <th>FECHA DE REGISTRO</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>

                    @foreach($data as $d)
                    <tr>
                        <td>#{{$d->id}}</td>
                        <td>{{$d->descripcion}}</td>
                        <td>{{$d->dias}}</td>
                        <td>{{$d->fecha}}</td>
                        <td>{{$d->created_at}}</td>
                        <td>

                            <form action="{{route('recopa.delete_recordatorio', [$d->id] ) }}" method="post">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('¿Estas Seguro de Eliminar?')"><i class="fa fa-fw fa-trash"></i> </button>
                            </form>

                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>


            <!-- Modal -->
            <div class="modal fade" id="diario" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">RECORDATORIO</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <form action="{{route('recopa.recordatorio')}}" method="post">
                            @csrf()
                            <input type="hidden" name="paciente_id" value="{{$paciente->id}}">
                            <div class="modal-body">

                                <div class="form-group">
                                    <label for="descripcion">DESCRIPCIÓN</label>
                                    <textarea class="form-control" name="descripcion" rows="5"></textarea>
                                </div>

                                <!-- <div class="form-group col-12">
                                    <label for="inputPassword4">DIAS ANTES</label>
                                    <input type="number" class="form-control" required name="dias">
                                </div> -->

                                <div class="form-group col-12">
                                    <label for="">FECHA DE RECORDATORIO</label>
                                    <input type="date" required name="fecha" class="form-control">
                                </div>


                            </div>
                            <div class="modal-footer">

                                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> GUARDARÁ</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>

@endsection