<!DOCTYPE html>
<html>

<head>
    <link rel="stylesheet" href="style.css">
    <title>{{config('app.name')}}</title>
    <!-- <link rel="shortcut icon" href="{{asset('assets/images/logo.ico')}}" type="image/x-icon"> -->
    <link rel="shortcut icon" href="{{asset('assets/images/logo.ico')}}" type="image/x-icon">

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Sarina">
    <script src="{{asset('plugins/fontaweson/fontaws.js')}}"></script>


</head>

<style>
    @media print {

        .oculto-impresion,
        .oculto-impresion * {
            display: none !important;
        }
    }




    * {
        font-size: 12px;
        font-family: system-ui;
        font-weight: 500;
    }

    .titulo {
        font-family: 'Sarina', serif;
        text-transform: capitalize;
    }


    td,
    th,
    tr,
    table {
        border-top: 1px solid black;
        border-collapse: collapse;
    }

    td.producto,
    th.producto {
        width: 165px;
        max-width: 165px;
    }

    td.cantidad,
    th.cantidad {
        width: 40px;
        max-width: 40px;
        word-break: break-all;
    }

    td.precio,
    th.precio {
        width: 50px;
        max-width: 50px;
        word-break: break-all;
    }

    .centrado {
        text-align: center;
        align-content: center;
    }

    .ticket {
        width: 285px;
        max-width: 357px;
    }

    img {
        max-width: inherit;
        width: inherit;
        -webkit-filter: grayscale(100%);
        filter: grayscale(100%);

    }
</style>

<body align="center">
    <div class="ticket">
        <div class="row">

            <img src="{{asset('logos/recibo.png')}}" style=" width: 60%" alt="">

            <div class="col-8">



                <div align="center">
                    <div style="font-size: 20px;">
                        <p class="text-uppercase text-center">
                            {{config('app.direccion')}}
                        </p>
                        <p class="text-center">
                            TELÉFONO: <span class="text-info">{{config('app.telefono')}}</span>
                        </p>
                    </div>
                </div>

                <div align="center">
                    <div class="text-right" style="font-size: 20px;">
                        <p class="text-uppercase text-center">
                            <b class="text-danger">RECIBO. 000{{$abono->id}}</b><br>
                            FECHA: {{$abono->created_at }} <br>
                        </p>
                    </div>
                </div>
            </div>

        </div>



        <div align="center">
            <p>NOMBRE: {{$paciente->nombre}} <span class="text-rigth"> <br> </span> </p>
            <p>TELEFONO: {{$paciente->telefono}} <span class="text-rigth"> <br> </span> </p>
            <table>
                <thead>
                    <tr>
                        <th class="cantidad">TIPO</th>
                        <th class="producto">DESCRIPCION</th>
                        <th class="precio">TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="cantidad">{{$abono->tipo}}</td>
                        <td class="producto">{{$abono->descripcion}}</td>
                        <td class="precio">Q.{{$abono->valor + $abono->incremento}}</td>
                    </tr>
                </tbody>
            </table>

        </div>




        <h5 class="text-right text-info" style="margin-bottom: 0px;">
            ABONADO: {{number_format($abono->valor, 2)}}
        </h5>



        @if ($paciente->abono < $paciente->deuda)
            <h5 style="margin: 0px;">
                SALDO PENDIENTE
                <b>Q. {{number_format($paciente->deuda - $paciente->abono, 2)}}</b>
            </h5>
            @elseif($paciente->abono > $paciente->deuda)
            <h5 style="margin: 0px;">
                TIENE A FAVOR Q.
                <b>
                    {{number_format($paciente->abono - $paciente->deuda, 2)}}
                </b>
            </h5>
            @elseif ($paciente->abono === $paciente->deuda)
            <h5 style="margin: 0px;">
                <b>
                    PAGOS AL DIA
                </b>
            </h5>
            @endif

            <p>PROXIMA CITA</p>
            <input type="date" style="text-align: center;border: 0px solid, 0p;">

            <p class="centrado">
                {{config('app.slogan')}}
                <br>{{config('app.name') }}
            </p>





    </div>

    <button class="oculto-impresion" onclick="imprimir()">Imprimir</button>


    <script>
        function imprimir() {
            window.print();
        }
    </script>

</body>

</html>