@extends('layouts.app')

@section('styles')
<style>
    @media print {

        .oculto-impresion,
        .oculto-impresion * {
            display: none !important;
        }
    }
</style>
@endsection

@section('content')

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col">
            <div class="card oculto-impresion">
                <div class="card-body text-center">
                    <h4 class="card-title">AGREGAR NUEVA RADIOGRAFIA</h4>
                    <form action="{{ route('paciente.radiografiastore')}}" method="post" enctype="multipart/form-data">
                        @csrf()
                        <input type="hidden" name="paciente_id" value="{{$paciente_id}}">

                        <div class="form-group col-md-6">
                            <label for="">TITULO</label>
                            <input type="text" class="form-control" name="titulo">
                        </div>

                        <div class="form-group">
                            <input type="file" class="form-control-file" name="foto" accept="image/png, image/jpeg,image/jpg, image/gif, application/pdf" max-file-size="3145728">
                            <small class="form-text text-muted">El archivo no debe superar los 3 MB.</small>
                        </div>
                        <button type="submit" class="btn btn-outline-success offset-3 mt-2">
                            <i class="fas fa-save    "></i> Guardar
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row p-4">
        <div class="col">

            <div class="page-body masonry-page">
                <!-- Gallery with description card start -->
                <h5 class="m-b-20">RADIOGRAFÍAS </h5>
                <div class="default-grid row" style="position: relative; height: 1545.64px;">
                    <div class="row lightboxgallery-popup">

                        @foreach ($fotos as $foto)

                        <div class="col-md-4 ">
                            <div class="card">
                                <img class="img-fluid rounded" src="{{asset('storage/' . 'pacientes/' . $foto->foto)}}">
                                <div class="card-body">
                                    <p class="card-text">TITULO: {{$foto->titulo}}</p>

                                    <p class="card-text">Fecha de Registro: {{$foto->created_at}}</p>
                                    <a class="btn btn-danger" href="{{route('paciente.readiografiadelete', ['id' => $foto->id])}}" role="button" onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i></a>


                                    <a class="btn btn-info" target="_blank" href="{{config('app.url')}}{{ Storage::url('pacientes/' . $foto->foto) }}" role="button"><i class="fa fa-eye" aria-hidden="true"></i></a>


                                    <a class="btn btn-success" href="{{config('app.url')}}{{ Storage::url('pacientes/' . $foto->foto) }}" download="{{$foto->titulo}}"><i class="fa fa-download" aria-hidden="true"></i></a>
                                </div>
                            </div>

                        </div>
                        @endforeach

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection