@extends('layouts.app')

@section('styles')
<style>
    @media print {

        .oculto-impresion,
        .oculto-impresion * {
            display: none !important;
        }

        /* .scale {
                                               transform: scale(0.90);
                                            } */
    }

    .bordes {
        border: 3px solid #81d112;
    }

    .tachado {
        text-decoration: line-through;
    }
</style>

<link rel="stylesheet" href="{{ asset('plugins/datatable/css/dataTables.bootstrap4.min.css') }}">
@endsection


@section('content')
<div class="cotainer-fluid">
    <div class="row">
        <div class="col">
            <h1 class="text-center text-uppercase ">procedimientos: {{ $paciente->nombre }} <!-- Button trigger modal -->

                @if ($hoja == 11)

                <br>
                <!-- Button trigger modal -->
                <button type="button" class="btn btn-success btn-lg" data-toggle="modal" data-target="#d_orto">
                    DIARIO ORTODONCIA
                </button>



                @else
                <button type="button" class="btn btn-primary  oculto-impresion" data-toggle="modal" data-target="#diario">
                    DIARIO
                </button>
                @endif
                <!--
                <a class="btn btn-info" target="_blank" href=" route('si.index', $paciente->id) ">
                    REGISTRAR SALIDA DE INSUMO
                </a> -->
            </h1>



            <div class="row">
                <div class="col">

                    <?php
                    $abono = $paciente->abonoModel->where('hoja', $hoja)->sum('valor') ?? 0;
                    $pro = $procedimientos->sum('valor');
                    $evalu = $procedimientos->where('fecha_realizacion', '!=', null)->sum('valor');
                    ?>
                    <p class="h4">
                        Total de Procedimientos: Q. {{ number_format($pro ?? 0, 2) }} <br>
                        Total Trabajado: Q. {{ number_format($evalu ?? 0, 2) }} <br>
                        <!-- Total Abondado: Q. {{ number_format($abono ?? 0, 2) }} <br>
                    Saldo Pendiente Trabajado: Q. {{ number_format($evalu - $abono ?? 0, 2) }} <br>
                    Saldo Pendiente Total : Q. {{ number_format($pro - $abono ?? 0, 2) }} <br> -->
                    </p>
                </div>
            </div>

            <table class="table table-sm bordes scale" id="table_id">
                <thead class="">
                    <tr class="bordes">
                        <th class="bordes">FECHA</th>
                        <th class="bordes">PIEZA</th>
                        <th class="bordes">TRATAMIENTO</th>
                        <th class="bordes">VALOR</th>
                        <th class="bordes">RECOMENDACIONES</th>
                        <th class="bordes">DOCTOR</th>
                        <th class="oculto-impresion">ACCION</th>
                    </tr>
                </thead>
                <tbody class="bordes">
                    @foreach ($procedimientos as $pro)
                    @if ($pro->deleted_at)
                    <tr class="bordes tachado">
                        <td class="bordes">{{ $pro->fecha_realizacion }}</td>
                        <td class="bordes">{{ $pro->pieza }}</td>
                        <td class="bordes">{{ $pro->tratamiento }} {{ $pro->descripcion }}, {{ $pro->tipo }}
                            <br>
                            Asigno: {{ $pro->name ?? 'SIN ASIGNACIÓN' }}
                        </td>
                        <td class="bordes">Q. {{ number_format($pro->valor, 2) }}</td>
                        <td class="bordes"></td>

                        @if ($pro->estado && $pro->fecha_realizacion)
                        <td class="bordes">{{ $pro->nombre }} / {{ $pro->asistio }}</td>
                        @else
                        <td class="bordes">

                        </td>
                        @endif

                        <td class="oculto-impresion ">
                            @can('delete_procedimiento')
                            @if (!$pro->estado && !$pro->fecha_realizacion)
                            <form action="{{ route('presup.setProcedimientoAndPago') }}" method="post">
                                @csrf


                                <div class="form-group oculto-impresion">
                                    <select class="form-control" name="doctor_id" required>
                                        <option value="">DOCTOR QUE OPERO</option>
                                        @foreach ($doctores as $doc)
                                        <option value="{{ $doc->id }}">{{ $doc->nombre }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>



                                <input type="hidden" value="{{ $paciente->id }}" name="paciente_id">
                                <input type="hidden" value="{{ $pro->trId }}" name="tratamiento_id">
                                <input type="hidden" value="{{ $pro->pieza }}" name="pieza">
                                <input type="hidden" value="{{ $pro->id }}" name="procedimiento_id">

                                <button type="submit" class="btn btn-primary"> <i class="fa fa-check-circle" aria-hidden="true"></i> </button>
                            </form>
                            @else
                            <form action="{{ route('presup.deleteProcedimientoAndPago') }}" method="post">
                                @csrf
                                @method('DELETE')

                                <input type="hidden" value="{{ $paciente->id }}" name="paciente_id">
                                <input type="hidden" value="{{ $pro->trId }}" name="tratamiento_id">
                                <input type="hidden" value="{{ $pro->pieza }}" name="pieza">
                                <input type="hidden" value="{{ $pro->id }}" name="procedimiento_id">
                                <input type="hidden" value="{{ $pro->doctorId }}" name="doctor_id">


                                @if ((searSalidaInsumo($paciente->id, $pro->id) != null) || ($pro->tipo3 !== 'SI'))
                                <span class="badge badge-info">SI REALIZADO</span>
                                @else
                                <span class="badge badge-danger">NO REALIZADO</span>
                                @endif

                                <button onclick="return confirm('¿Esta Seguro de Eliminar El Pago?')" type="submit" class="btn btn-danger"> <i class="fa fa-trash" aria-hidden="true"></i> </button>
                            </form>
                            @endif
                            @endcan

                        </td>
                    </tr>
                    @else
                    <tr class="bordes">
                        <td class="bordes">{{ $pro->fecha_realizacion }}</td>
                        <td class="bordes">{{ $pro->pieza }}</td>
                        <td class="bordes">{{ $pro->tratamiento }} {{ $pro->descripcion }},
                            {{ $pro->tipo }} <br>
                            Asigno: {{ $pro->name ?? 'SIN ASIGNACION' }}
                        </td>
                        <td class="bordes">Q. {{ number_format($pro->valor, 2) }}</td>
                        <td class="bordes">{{ $pro->recomendacion }}</td>

                        @if ($pro->estado && $pro->fecha_realizacion)
                        <td class="bordes">{{ $pro->nombre }} / {{ $pro->asistio }}</td>
                        @else
                        <td class="bordes">

                        </td>
                        @endif

                        <td class="oculto-impresion ">

                            @if (!$pro->estado && !$pro->fecha_realizacion)
                            <form action="{{ route('presup.setProcedimientoAndPago') }}" method="post">
                                @csrf


                                <div class="form-group oculto-impresion">
                                    <select class="form-control" name="doctor_id" required>
                                        <option value="">DOCTOR QUE OPERO</option>
                                        @foreach ($doctores as $doc)
                                        <option value="{{ $doc->id }}">{{ $doc->nombre }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>



                                <input type="hidden" value="{{ $paciente->id }}" name="paciente_id">
                                <input type="hidden" value="{{ $pro->trId }}" name="tratamiento_id">
                                <input type="hidden" value="{{ $pro->pieza }}" name="pieza">
                                <input type="hidden" value="{{ $pro->id }}" name="procedimiento_id">

                                @can('delete_procedimiento')
                                <button type="submit" onclick="return confirm('Esta Seguro de Asignar el Pago ?')" class="btn btn-primary"> <i class="fa fa-check-circle" aria-hidden="true"></i> </button>
                                @endcan

                                <!-- <button type="submit" class="btn btn-info"><i class="fa fa-check-circle" aria-hidden="true"></i></button> -->


                                <a class="btn btn-success" target="_blank" href="{{route('si.index', [$paciente->id, $pro->id] )}}"> <i class="fas fa-syringe    "></i> </a>

                            </form>
                            @else
                            <form action="{{ route('presup.deleteProcedimientoAndPago') }}" method="post">
                                @csrf
                                @method('DELETE')

                                <input type="hidden" value="{{ $paciente->id }}" name="paciente_id">
                                <input type="hidden" value="{{ $pro->trId }}" name="tratamiento_id">
                                <input type="hidden" value="{{ $pro->pieza }}" name="pieza">
                                <input type="hidden" value="{{ $pro->id }}" name="procedimiento_id">
                                <input type="hidden" value="{{ $pro->doctorId }}" name="doctor_id">

                                <!-- {{ $pro->fecha_realizacion }} -->



                                <!-- 1 SI EXISTE UNA SALIDA || TIPO3 ! == SI  -->
                                @if ((searSalidaInsumo($paciente->id, $pro->fecha_realizacion) != null) || ($pro->tipo3 !== 'SI'))
                                <span class="badge badge-info">SI REALIZADO</span>
                                @else
                                <span class="badge badge-danger">NO REALIZADO </span>
                                @endif


                                <!-- validamos para desbloquear -->
                                @if ($pro->bloqueo != 'SI') <a class="btn btn-success" target="_blank" href="{{route('si.index', [$paciente->id, $pro->id] )}}"> <i class="fas fa-syringe    "></i> </a>
                                @endif


                                @can('delete_procedimiento')
                                <button onclick="return confirm('¿Esta Seguro de Eliminar El Pago?')" type="submit" class="btn btn-danger"> <i class="fa fa-trash" aria-hidden="true"></i> </button>
                                @endcan
                            </form>
                            @endif

                        </td>
                    </tr>
                    @endif
                    @endforeach

                </tbody>
            </table>





            <!-- Modal -->
            <div class="modal fade" id="diario" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">DATOS DE DIARIO</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <a target="_blank" class="btn btn-primary" href="{{ route('diario.index', ['id' => $paciente->id]) }}"> IR A DIARIO</a>

                        <form action="{{ route('diario.store') }}" method="post">
                            @csrf
                            <input type="hidden" name="paciente_id" value="{{ $paciente->id }}">
                            <div class="modal-body">

                                <div class="form-group">
                                    <label for="exampleInputEmail1">DOCTOR </label>
                                    <input type="text" name="doctor" class="form-control">
                                </div>


                                <div class="form-group">
                                    <label for="descripcion">ESTA CITA:</label>
                                    <textarea class="form-control" name="descripcion" rows="5"></textarea>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputtext1">PIEZA</label>
                                    <input type="text" class="form-control" name="piezas">
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputtext1">PROXIMA CITA</label>
                                    <input type="text" class="form-control" name="proxima">
                                </div>

                            </div>
                            <div class="modal-footer">

                                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i>
                                    GUARDAR</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>


            <!-- Modal -->
            <div class="modal fade" id="d_orto" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog modal-lg" style="max-width: 80% !important;">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">DIARIO ORTODONCIA</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <form action="{{ route('diario.store') }}" method="post">
                                        @csrf
                                        <input type="hidden" name="paciente_id" value="{{ $paciente->id }}">
                                        <div class="modal-body">

                                            <input type="text" name="hoja" value="{{$hoja}}" class="form-control oculto-impresion" hidden>
                                            <input type="text" name="tipo" value="ORTODONCIA" class="form-control oculto-impresion" hidden>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">DOCTOR </label>
                                                <input type="text" name="doctor" class="form-control">
                                            </div>


                                            <div class="form-group">
                                                <label for="descripcion">ESTA CITA:</label>
                                                <textarea class="form-control" name="descripcion" rows="5"></textarea>
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputtext1">PIEZA</label>
                                                <input type="text" class="form-control" name="piezas">
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputtext1">PROXIMA CITA</label>
                                                <input type="text" class="form-control" name="proxima">
                                            </div>

                                        </div>
                                        <div class="modal-footer">

                                            <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i>
                                                GUARDAR</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-6">

                                    <table class="table table-sm">
                                        <thead>
                                            <tr>
                                                <th>DOCTOR</th>
                                                <th>ESTA CITA:</th>
                                                <th>PIEZA</th>
                                                <th>PROXIMA CITA</th>
                                                <th>F. Registro</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($diario as $item)
                                            <tr>
                                                <td>{{ $item->doctor }}</td>
                                                <td>{{ $item->descripcion }}</td>
                                                <td>{{ $item->piezas }}</td>
                                                <td>{{ $item->proxima }}</td>
                                                <td>{{ $item->created_at }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>


                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection



@section('scripts')
<script src="{{ asset('plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatable/js/dataTables.bootstrap4.min.js') }}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection