<!DOCTYPE html>
<html dir="ltr" lang="es">

<head>

   <title>{{config('app.name')}}</title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
   <meta name="author" content="DeCoDev Desarrollo de Software">
   <!-- Favicon icon -->
   <link rel="icon" href="{{asset('logos/ico.ico')}}" type="image/x-icon">
   <script src="{{asset('plugins/fontaweson/fontaws.js')}}"></script>
   <link rel="stylesheet" href="{{asset('plugins/bootstrap/bootstrap.min.css')}}">
   <link href="{{ asset('styles.css') }}" rel="stylesheet">

   <style>

   </style>

   <link rel="stylesheet" href="{{asset('agrupado.css')}}">

   <style>
      .total {
         background-color: #d6ecad;
      }
   </style>
</head>

<body>



   <div class="text-center mb-3 mt-5">
      <a href="{{route('home')}}">
         <img class="rounded shadow-sm" style="width: 25%;" src="{{asset('logos/icono.jpg')}}" alt="{{config('app.name')}}">
      </a>
   </div>

   <div class="text-center odo">Odontologia General</div>


   <div class="text-center direcc d1">{{config('app.direccion')}}</div>
   <div class="text-center direcc">Tel. {{config('app.telefono')}}, Email: {{config('app.email')}}</div>

   <div class="line"></div>



   <div class="container-fluid">

      @include('includes.alerts')

      <div class="container">
         <div class="row">
            <div class="col">


               <div class="nombre">NOMBRE DEL PACIENTE: <b> {{$paciente->nombre}}</b> </div>

               <div class="fecha">FECHA: <?php echo date("d-m-Y"); ?></div>

               <div class="contenido">
                  <div class="titulo text-center">PRESUPUESTO</div>

                  <table class="table bordes">
                     <thead>
                        <tr>
                           <th style="color: black;">No.</th>
                           <th style="color: black;">TRATAMIENTO</th>
                           <th style="color: black;">VALOR UNITARIO</th>
                           <th style="color: black;">VALOR TOTAL</th>
                        </tr>
                     </thead>
                     <tbody>
                        <?php $total = 0; ?>
                        @foreach ($data as $d)
                        <?php
                        $aux = 0;
                        $aux = $d->valor *  $d->numero;
                        $total += $aux;
                        ?>
                        <tr>
                           <td>{{$d->numero}}</td>
                           <td>{{$d->nombre}}, {{$d->descripcion}}</td>
                           <td class="text-right">Q. {{number_format($d->valor,2)}}</td>
                           <td class="text-right">Q. {{number_format($aux,2)}}</td>
                        </tr>
                        @endforeach
                     </tbody>
                  </table>

                  <div class="total text-right">TOTAL: Q. {{number_format($total,2)}}</div>

                  @if ($paciente->firma)
                  <p style="margin-top: 2%; text-align: center;">
                     <img src="{{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" style="width: 25%;" alt=""><br>
                     F. ______________________________
                     <br>
                     Firma de aprobación de Presupuesto

                  </p>
                  @else
                  <p style="margin-top: 6%; text-align: center;">
                     F. ______________________________ <br>
                     Firma de aprobación de Presupuesto
                  </p>
                  @endif

                  <p>
                     <b>Notas:</b> <br>
                     - Presupuesto válido por <input type="text" style="font-weight: bold; border-top: 0px; border-left: 0px; border-right: 0px;"> <br>
                     - El éxito de su tratamiento también dependerá de sus cuidados.

                  </p>

                  <div class="mensaje text-center">Será un gusto poder servirle, ¡Dios le bendiga!</div>

               </div>


            </div>
         </div>
      </div>


   </div>


   <script src="{{asset('plugins/bootstrap/jquery.min.js')}}"></script>
   <script src="{{asset('plugins/bootstrap/popper.min.js')}}"></script>
   <script src="{{asset('plugins/bootstrap/bootstrap.min.js')}}"></script>

</body>

</html>