@extends('layouts.app')

@section('styles')
<style>
    @media print {

        .oculto-impresion,
        .oculto-impresion * {
            display: none !important;
        }

        /* .scale {
         transform: scale(0.90);
      } */
    }

    .bordes {
        border: 3px solid #81d112;
    }

    .tachado {
        text-decoration: line-through;
    }
</style>

@endsection


@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col">
            <h1 class="text-center display-4 text-uppercase "> Presupuesto De {{$paciente->nombre}} </h1>

            @php
            $total = 0;
            @endphp
            <table class="table table-sm bordes scale">
                <thead class="">
                    <tr class="bordes">
                        <th class="bordes">PIEZA</th>
                        <th class="bordes">TRATAMIENTO</th>
                        <th class="bordes">FECHA ACTUALIZACIÓN</th>
                        <th class="bordes">VALOR</th>
                        <th class="oculto-impresion">ACCION</th>
                    </tr>
                </thead>
                <tbody class="bordes">
                    @foreach ($presupuestos as $pres )
                    @if ($pres->deleted_at)
                    <tr class="bordes tachado">
                        <td class="bordes">{{$pres->pieza}}</td>
                        <td class="bordes">{{$pres->nombre}} {{$pres->descripcion}}, {{$pres->tipo}}</td>
                        <td class="bordes">{{$pres->fecha}}</td>
                        <td class="bordes">Q. {{number_format($pres->valor, 2)}}</td>
                        <td class="oculto-impresion ">
                            <a class="btn btn-primary" href="{{route('presup.restore', $pres->id)}}" role="button"><i class="fa fa-check" aria-hidden="true"></i></a>
                            <form action="{{route('presup.updatePresupuesto')}}" method="post">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="id" value="{{$pres->id}}">
                                <select name="pieza" class="form-control mt-2 oculto-impresion">
                                    <option value="{{$pres->pieza}}">{{$pres->pieza}}</option>
                                    @include('admin.pacientes.data.piezas')
                                </select>
                                <select name="tratamiento_id" class="form-control my-2 oculto-impresion">
                                    <option value="{{$pres->tratamiento_id}}">{{$pres->nombre}} {{$pres->descripcion}}, {{$pres->tipo}}</option>
                                    @foreach ($tratamientos as $tr)
                                    <option value="{{$tr->id}}">{{$tr->nombre}} {{$tr->descripcion}} {{$tr->tipo}}</option>
                                    @endforeach
                                </select>
                                <button type="submit" class="btn btn-warning" onclick="return confirm('¿Esta Seguro de Actualizar?')"><i class="fa fa-sync    "></i></button>
                            </form>
                        </td>
                    </tr>
                    @else
                    @php
                    $total = $total + $pres->valor;
                    @endphp
                    <tr class="bordes">
                        <td class="bordes">{{$pres->pieza}}</td>
                        <td class="bordes">{{$pres->nombre}} {{$pres->descripcion}}, {{$pres->tipo}}</td>
                        <td class="bordes">{{$pres->fecha}}</td>
                        <td class="bordes">Q. {{number_format($pres->valor, 2)}}</td>
                        <td class="oculto-impresion ">
                            <form action="{{route('presup.delete', ['id' => $pres->id])}}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" onclick="return confirm('¿Esta Seguro de Eliminar?')" class="btn btn-danger btn-xs" title="Elimiar del Presupuesto" data-toggle="tooltip"><i class="fa fa-trash" aria-hidden="true"></i></button>
                            </form>
                            <form action="{{route('presup.updatePresupuesto')}}" method="post">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="id" value="{{$pres->id}}">
                                <select name="pieza" class="form-control mt-2 oculto-impresion">
                                    <option value="{{$pres->pieza}}">{{$pres->pieza}}</option>
                                    @include('admin.pacientes.data.piezas')
                                </select>
                                <select name="tratamiento_id" class="form-control my-2 oculto-impresion">
                                    <option value="{{$pres->tratamiento_id}}">{{$pres->nombre}} {{$pres->descripcion}}, {{$pres->tipo}}</option>
                                    @foreach ($tratamientos as $tr)
                                    <option value="{{$tr->id}}">{{$tr->nombre}} {{$tr->descripcion}} {{$tr->tipo}}</option>
                                    @endforeach
                                </select>
                                <button type="submit" class="btn btn-warning" onclick="return confirm('¿Esta Seguro de Actualizar?')"><i class="fa fa-sync    "></i></button>
                            </form>
                        </td>
                    </tr>
                    @endif
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="row">
        <div class="col">
            <p class="h3 text-center text-info">Total: Q. {{number_format($total, 2)}}</p>
        </div>
    </div>
</div>


@endsection