@extends('layouts.app')

@section('content')

<div class="container-fluid px-5">

    <div class="row">
        <div class="col">
            <p class="text-center text-uppercase h1">PERIODONTOGRAMAS DE: {{$paciente->nombre}}
                <button type="button" class="btn btn-primary btn-lg oculto-impresion" data-toggle="modal" data-target="#diario">
                    NUEVO
                </button>
                <a target="_blank" class="btn btn-info" href="https://www.periodontalchart-online.com/es/" role="button">IR A PERIODONTOGRAMA</a>
            </p>


            <div class="row">
                @forelse ($data as $pe)
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Fecha de Asignación: {{$pe->created_at}}</h4>
                            <a class="btn btn-primary" target="_blank" href="
                     {{config('app.url')}}{{Storage::url('paciente/periodonto/'.$pe->documento)}}"><i class="fa fa-download" aria-hidden="true"></i> DESCARGAR</a>
                        </div>
                    </div>
                </div>

                @empty
                <div class="alert alert-info" role="alert">
                    <strong>SIN DATOS REGISTRADOS</strong>
                </div>
                @endforelse
            </div>


            <!-- Modal -->
            <div class="modal fade" id="diario" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">NUEVO PERIODONTOGRAMA</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <form action="{{route('perio.store')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="paciente_id" value="{{$paciente->id}}">
                            <div class="modal-body">

                                <div class="form-group">
                                    <label for="">PERIODONTOGRAMA</label>
                                    <input type="file" class="form-control-file" name="documento" required accept="*">


                                </div>

                            </div>
                            <div class="modal-footer">

                                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> GUARDARÁ</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>

@endsection