@extends('layouts.app')

@section('content')

<div class="container-fluid">

    <div class="row">
        <div class="col">

            <p class="text-center display-5">PACIENTES {{$estado}}</p>

            <table class="table" id="table_id">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Teléfono</th>
                        <th>Dirección</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($pacientes as $paciente)
                    <tr>
                        <td>{{ $paciente->nombre }}</td>
                        <td>{{ $paciente->telefono }}</td>
                        <td>{{ $paciente->direccion }}</td>
                        <td>{{ $paciente->estado }}</td>
                    </tr>
                    @endforeach


                </tbody>
            </table>

            <p class="display-5">Total de Pacientes: <?php echo count($pacientes); ?> </p>

        </div>
    </div>
</div>


@endsection

@section('scripts')
<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>
@endsection