@extends('layouts.app')

@section('content')

<div class="container-fluid">
   @if (!$data)
   <div class="row">
      <div class="col">

         <!-- Button trigger modal -->
         <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#modelId">
            CARGAR DPI
         </button>

         <!-- Modal -->
         <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
            <div class="modal-dialog" role="document">
               <div class="modal-content">
                  <div class="modal-header">
                     <h5 class="modal-title">INGRESAR FOTOS DE DPI</h5>
                     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                     </button>
                  </div>
                  <form action="{{route('escan.store')}}" enctype="multipart/form-data" method="post">
                     @csrf
                     <input type="hidden" name="paciente_id" value="{{$id}}">
                     <div class="modal-body">
                        <div class="form-group">
                           <label for="">LADO 1</label>
                           <input type="file" class="form-control-file" name="lado1">
                        </div>
                        <div class="form-group">
                           <label for="">LADO 2</label>
                           <input type="file" class="form-control-file" name="lado2">
                        </div>
                     </div>
                     <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
                        <button type="submit" class="btn btn-primary"><i class="fas fa-save    "></i> GUARDAR</button>
                     </div>
                  </form>
               </div>
            </div>
         </div>

      </div>
   </div>

   @else


   <div class="row">

      <div class="col-md-6">
         <div class="card">
            <img class="card-img-top" src="{{config('app.url')}}{{Storage::url('/pacientes/dpi/'.$data->foto1)}}" alt="{{config('app.name')}}">
         </div>
      </div>

      <div class="col-md-6">
         <div class="card">
            <img class="card-img-top" src="{{config('app.url')}}{{Storage::url('/pacientes/dpi/'.$data->foto2)}}" alt="{{config('app.name')}}">
         </div>
      </div>

   </div>

   @endif

</div>

@endsection