@extends('layouts.app')

@section('content')

<div class="container-fluid px-5">

    <div class="row">
        <div class="col">
            <p class="text-center text-uppercase h1">DIARIO DE {{$tipo}}: {{$paciente->nombre}}
                @if ($tipo !== 'ORTODONCIA')

                <button type="button" class="btn btn-primary btn-lg oculto-impresion" data-toggle="modal" data-target="#diario">
                    DIARIO
                </button>
                @endif
            </p>


            <table class="table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>ESTA CITA</th>
                        <th>Doctor</th>
                        <th>PIEZA</th>
                        <th>PROXIMA CITA</th>
                        <th>FECHA</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $d)
                    {{-- Conditionally render row based on $tipo --}}
                    /* Si $tipo es ORTODONCIA, solo mostramos las filas que tambien tengan tipo ORTODONCIA.
                    Si $tipo NO es ORTODONCIA, solo mostramos las filas que NO tengan tipo ORTODONCIA */
                    @if (($tipo !== 'ORTODONCIA' && $d->tipo !== 'ORTODONCIA') || ($tipo === 'ORTODONCIA' && $d->tipo === 'ORTODONCIA'))

                    <tr>
                        <td>#{{$d->id}} / {{$d->tipo}}</td>
                        <td>{{$d->descripcion}}</td>
                        <td>{{$d->doctor}}</td>
                        <td>{{$d->piezas}}</td>
                        <td>{{$d->proxima}}</td>
                        <td>{{$d->created_at}}</td>
                        <td>
                            <form action="{{route('diario.destroy', ['id' => $d->id])}}" method="post">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás Seguro de Eliminar?')"><i class="fa fa-fw fa-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    @endif
                    @endforeach
                </tbody>
            </table>

            <!-- Modal -->
            <div class="modal fade" id="diario" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">DATOS DE DIARIO</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <a target="_blank" class="btn btn-primary" href="{{route('diario.index', ['id' => $paciente->id])}}"> IR A DIARIO</a>

                        <form action="{{route('diario.store')}}" method="post">
                            @csrf
                            <input type="hidden" name="paciente_id" value="{{$paciente->id}}">
                            <div class="modal-body">

                                <div class="form-group">
                                    <label for="exampleInputEmail1">DOCTOR </label>
                                    <input type="text" name="doctor" class="form-control">
                                </div>


                                <div class="form-group">
                                    <label for="descripcion">ESTA CITA:</label>
                                    <textarea class="form-control" name="descripcion" rows="5"></textarea>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputtext1">PIEZA</label>
                                    <input type="text" class="form-control" name="piezas">
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputtext1">PROXIMA CITA</label>
                                    <input type="text" class="form-control" name="proxima">
                                </div>



                            </div>
                            <div class="modal-footer">

                                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> GUARDARÁ</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>

@endsection