@extends('layouts.app')


@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">

                <p class="h1 text-center">Pacientes Deudores</p>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" id="table_id">
                            <thead class="thead">
                                <tr>
                                    <th>No</th>

                                    <th>Nombre</th>
                                    <th>Teléfono</th>
                                    <th>Dirección</th>
                                    <th>Tipo</th>
                                    <th>Total Deuda</th>

                                </tr>
                            </thead>
                            <tbody>
                                @for($i = 0; $i < count($pacientes);$i++) <tr>
                                    <td>{{ $pacientes[$i]->id }}</td>
                                    <td>{{ $pacientes[$i]->nombre }}</td>
                                    <td>{{ $pacientes[$i]->telefono }}</td>
                                    <td>{{ $pacientes[$i]->direccion }}</td>
                                    <td>{{ $pacientes[$i]->tipo }}</td>
                                    <td>Q. {{ number_format($pacientes[$i]->deuda - $pacientes[$i]->abono, 2) }}</td>

                                    </tr>
                                    @endfor
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection

@section('scripts')
<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>
@endsection