@extends('layouts.app')

@section('content')
<div class="container">


    <div class="row">
        <div class="col">

            <p class="text-center text-uppercase h1 my-5">DEUDA DE MEDICAMENTO PACIENTE {{$nombre}}</p>

            <!-- Button trigger modal -->
            <button type="button" class="btn btn-primary oculto-impresion" data-toggle="modal" data-target="#modelId">
                ASIGNAR DEUDA
            </button>
            <!-- Modal -->
            <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">NUEVA DEUDA DE MEDICAMENTO</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{route('deuda.storeDeudaMedicamento')}}" method="post">
                            @csrf
                            <div class="modal-body">
                                <input type="hidden" value="{{$paciente}}" name="paciente_id">
                                <div class="form-group">
                                    <label for="total">TOTAL</label>
                                    <input type="number" class="form-control" name="total" id="total">
                                </div>
                                <div class="form-group">
                                    <label for="descripcion">DESCRIPCIÓN</label>
                                    <input type="text" class="form-control text-uppercase" name="descripcion" id="descripcion">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
                                <button type="submit" class="btn btn-primary">GUARDAR</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<div class="continer">
    <div class="row">
        <div class="col">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>DESCRIPCIÓN</th>
                            <th>TOTAL</th>
                            <th>FECHA DE DEUDA</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pendientes as $pen)
                        <tr>
                            <td>No. {{$pen->id}}</td>
                            <td>{{$pen->descripcion}}</td>
                            <td>Q. {{number_format($pen->total, 2)}}</td>
                            <td>{{$pen->created_at}}</td>
                            <td>
                                <form action="{{route('deuda.deleteDeudaMedicamento', ['id' => $pen->id])}}" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('¿Esta Seguro de Realizar Pago?')"><i class="fa fa-check" aria-hidden="true"></i></button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


@endsection