@extends('layouts.admin')

@section('content')
<div class="cotainer-fluid">
    <div class="row">
        <div class="col">



            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>PACIENTE</th>
                            <th>TIPO DE ABONO</th>
                            <th>VALOR</th>
                            <th>DESCRIPCIÓN</th>
                            <th>RECIBO</th>
                            <th>FACTURA</th>
                            <th>FECHA DE ABONO</th>
                            <th class="oculto-impresion">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                        $totalAbonado = 0;
                        @endphp
                        @foreach ($abonos as $abono)
                        <tr>
                            <td>{{$abono->paciente->nombre}}</td>
                            <td>{{$abono->tipo}}</td>
                            <td>Q. {{number_format($abono->valor + $abono->incremento, 2)}}</td>
                            <td>{{$abono->descripcion}}</td>
                            <td scope="row">00{{$abono->id}}</td>
                            <td>{{$abono->factura}}</td>
                            <td>{{$abono->created_at}}</td>
                            <td class="oculto-impresion">
                            </td>
                        </tr>
                        @php
                        $totalAbonado += $abono->valor + $abono->incremento;
                        @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>

            <p style="font-size: 210%">TOTAL ABONADO: Q. {{number_format($totalAbonado, 2)}}</p>

        </div>
    </div>
</div>
@endsection