@extends('layouts.app')

@section('styles')
<style>
    @media print {

        .oculto-impresion,
        .oculto-impresion * {
            display: none !important;
        }
    }

    .bordes {
        border: 3px solid #81d112;
    }
</style>

<link rel="stylesheet" href="{{ asset('plugins/slim-select/slimselect.min.css') }}">
@endsection

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">
            <p class="h1 text-uppercase text-center">Abonos: {{ $paciente }}</p>

            <!-- Button trigger modal -->
            <div class="oculto-impresion">
                @can('abono_store')
                <button type="button" class="btn btn-primary btn-block my-4 " data-toggle="modal" data-target="#modelId">
                    ABONAR
                </button>
                @endcan
                <a class="btn btn-info btn-block my-2" href="{{ route('agenda.index') }}"><i
                        class="fas fa-calendar-week"></i> AGENDAR</a>
            </div>



            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>TRATAMIENTO</th>
                            <th>TIPO DE ABONO</th>
                            <th>VALOR</th>
                            <th>DESCRIPCIÓN</th>
                            <th>RECIBO</th>
                            <th>FACTURA</th>
                            <th>FECHA DE ABONO</th>
                            <th class="oculto-impresion">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                        $totalAbonado = 0;
                        @endphp
                        @foreach ($abonos as $abono)
                        <tr>
                            <td>
                            </td>
                            <td>{{ $abono->tipo }}</td>
                            <td>Q. {{ number_format($abono->valor + $abono->incremento, 2) }}</td>
                            <td>{{ $abono->descripcion }}</td>
                            <td scope="row">00{{ $abono->id }}</td>
                            <td>{{ $abono->factura }}</td>
                            <td>{{ $abono->created_at }}</td>
                            <td class="oculto-impresion">

                                @can('abono_delete')
                                <a href="{{ route('abono.delete', ['id' => $abono->id]) }}"
                                    onclick="return confirm('¿Esta Seguro de Eliminar Abono?')"
                                    class="btn btn-danger"> <i class="fa fa-trash" aria-hidden="true"></i> </a>
                                @endcan
                                @can('abono_recibo')
                                <a target="_blank" href="{{ route('abono.pritnRecibo', ['id' => $abono->id]) }}"
                                    class="btn  btn-info"> <i class="fa fa-print" aria-hidden="true"></i> </a>
                                @endcan
                            </td>
                        </tr>
                        @php
                        $totalAbonado += $abono->valor + $abono->incremento;
                        @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>

            <p style="font-size: 210%">TOTAL ABONADO: Q. {{ number_format($totalAbonado, 2) }}</p>


            @can('abono_store')
            <!-- Modal -->
            <div class="modal fade oculto-impresion" id="modelId" tabindex="-1" role="dialog"
                aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">INGRESAR ABONO</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{ route('abono.store') }}" method="post">
                            @csrf
                            <div class="modal-body">

                                <input type="hidden" value="{{ $id }}" name="paciente_id">


                                <select name="tratamiento_id" id="tratamiento_id" class="form-control">
                                    <option value="">Seleccione Tratamiento</option>
                                    @foreach ($deudaPaciente as $tratamiento)
                                    <option value="{{ $tratamiento->tratamiento_id }}">
                                        {{ $tratamiento->tratamiento->nombre ?? '' }} -
                                        {{ $tratamiento->tratamiento->descripcion ?? '' }} - Q
                                        .{{ number_format($tratamiento->valor ?? 0, 2) }}
                                    </option>
                                    @endforeach
                                </select>

                                <div class="form-group">
                                    <label for="">TIPO DE ABONO</label>
                                    <select class="form-control" name="tipo">
                                        <option value="EFECTIVO">EFECTIVO</option>
                                        <option value="VISA">VISA</option>
                                        <option value="TRANSFERENCIA">TRANSFERENCIA</option>
                                        <option value="DEPOSITO">DEPOSITO</option>
                                        <option value="OTRO">OTRO</option>
                                    </select>
                                </div>



                                <div class="form-group">
                                    <label for="">VALOR</label>
                                    <input type="number" class="form-control" name="valor" step="any"
                                        id="valor">
                                </div>

                                <div class="form-group">
                                    <label for="">DESCRIPCION</label>
                                    <textarea class="form-control" name="descripcion" rows="3"></textarea>
                                </div>

                                <!-- <div class="form-group">
                                                                                                                                                                                                                                                                           <label for="">RECIBO</label>
                                                                                                                                                                                                                                                                           <input type="text" class="form-control" name="recibo" placeholder="Numero de Recibo">
                                                                                                                                                                                                                                                                        </div> -->

                                <div class="form-group">
                                    <label for="">FACTURA</label>
                                    <input type="text" class="form-control" name="factura"
                                        placeholder="Numero de Factura">
                                </div>

                                <p>
                                    <a class="btn btn-primary" data-toggle="collapse" href="#contentId"
                                        aria-expanded="false" aria-controls="contentId">
                                        MAS DATOS DE TARJETA
                                    </a>
                                </p>
                                <div class="collapse" id="contentId">


                                    <div class="form-group">
                                        <label for="">PORCENTAJE</label>
                                        <input type="text" class="form-control" name="porcentaje" id="porcentaje">
                                    </div>

                                    <div class="form-group">
                                        <label for="incremento">INCREMENTO</label>
                                        <input type="text" class="form-control" name="incremento"
                                            id="incremento">
                                    </div>

                                    <div class="form-group">
                                        <label for="">TOTAL POS</label>
                                        <input type="text" class="form-control" id="pos">
                                    </div>

                                    <button type="button" class="btn btn-success" onclick="calcular()"><i
                                            class="fa fa-calculator" aria-hidden="true"></i></button>


                                </div>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i
                                        class="fas fa-window-close"></i>CANCELAR
                                </button>
                                <button type="submit" class="btn btn-primary"> <i class="fas fa-save "></i>
                                    GUARDAR</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            @endcan

        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    var incremento = document.getElementById('incremento');
    var porcentaje = document.getElementById('porcentaje');
    var valor = document.getElementById('valor');
    var pos = document.getElementById('pos');
    const calcular = () => {


        // console.log(incremento.value, porcentaje.value, valor.value);

        let aux = valor.value * porcentaje.value / 100;


        incremento.value = aux;

        pos.value = parseFloat(aux) + parseFloat(valor.value);

        // console.log(parseFloat(aux));

    };
</script>

<script src="{{ asset('plugins/slim-select/slimselect.min.js') }}"></script>
<script>
    setTimeout(function() {
        new SlimSelect({
            select: '#tratamiento_id',
            placeholder: 'SELECCIONE SU TRATAMIENTO',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300)
</script>
@endsection