<!DOCTYPE html>
<html>

<head>
   <link rel="stylesheet" href="style.css">
   <title>Recibo</title>
   <!-- <link rel="shortcut icon" href="{{asset('assets/images/logo.ico')}}" type="image/x-icon"> -->
   <link rel="shortcut icon" href="{{asset('assets/images/logo.ico')}}" type="image/x-icon">
   <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Sarina">
   <script src="{{asset('plugins/fontaweson/fontaws.js')}}"></script>

</head>

<style>
   @media print {

      .oculto-impresion,
      .oculto-impresion * {
         display: none !important;
      }
   }


   * {
      font-size: 12px;
      font-family: system-ui;
      font-weight: 500;
   }

   .titulo {
      font-family: 'Sarina', serif;
      text-transform: capitalize;
   }

   td,
   th,
   tr,
   table {
      border-top: 1px solid black;
      border-collapse: collapse;
   }

   td.producto,
   th.producto {
      width: 175px;
      max-width: 175px;
   }

   td.cantidad,
   th.cantidad {
      width: 40px;
      max-width: 40px;
      word-break: break-all;
   }

   td.precio,
   th.precio {
      width: 40px;
      max-width: 40px;
      word-break: break-all;
   }

   .centrado {
      text-align: center;
      align-content: center;
   }

   .ticket {
      width: 285px;
      max-width: 357px;
   }

   img {
      max-width: inherit;
      width: inherit;
   }
</style>

<body align="center">
   <div class="ticket">
      <div class="row">

         <img src="{{asset('logos/recibo.png')}}" style=" width: 60%" alt="">


         <div class="col-8">



            <div align="center">
               <div style="font-size: 20px;">
                  <p class="text-uppercase text-center">
                     {{config('app.direccion')}}
                  </p>
                  <p class="text-center">
                     Teléfono: <span class="text-info">{{config('app.telefono')}}</span>
                  </p>
               </div>
            </div>

            <div align="center">

               <h3 class="text-capitalize text-center">Datos De Venta</h3>
               <div class="text-right" style="font-size: 20px;">
                  <p class="text-uppercase text-center">
                     <b class="text-danger">Recibo No. 000{{$ort->id}}</b><br>
                     Fecha de Venta: <?php echo date('d-m-Y') ?> <br>
                  </p>
               </div>
            </div>
         </div>

      </div>



      <div align="center">


         <p>Nombre: {{$ort->paciente}} <span class="text-rigth"> <br> </span> </p>


         <p>
            <br>
            Abono de Ortodoncia <br>
         </p>

      </div>



      <div class="row">


         <div class="col">

            <h5 class="text-right text-info">
               <p>Total Abonado: Q. {{number_format($ort->total, 2)}}</p>

            </h5>
         </div>
      </div>


      <p class="centrado">¡GRACIAS POR SU COMPRA!
         <br>{{config('app.name') }}
      </p>





   </div>

   <button class="oculto-impresion" onclick="imprimir()">Imprimir</button>


   <script>
      function imprimir() {
         window.print();
      }
   </script>

</body>

</html>