@extends('layouts.app')

@section('content')

<h1 class="text-center">PACIENTES ORTODONCIA</h1>

<div class="row">
    <div class="col card p-4 ">
        <table class="table" id="tblData">
            <thead>
                <tr>
                    <th>PACIENTE</th>
                    <th>DOCTOR</th>
                    <th>G. DOCTOR</th>
                    <th>CLÍNICA</th>
                    <th>TOTAL</th>
                    <th>OTROS</th>
                    <th></th>

                </tr>
            </thead>
            <tbody>
                <?php $t = 0;
                $t2 = 0;
                $t3 = 0; ?>

                @foreach ($orto as $o)

                <?php
                $t += $o->g_doc;
                $t2 += $o->g_cli;
                $t3 += $o->total;
                ?>
                <tr>
                    <td>{{$o->paciente}} </td>
                    <td>{{$o->doctor->nombre}}</td>
                    <td>Q. {{number_format($o->g_doc, 2)}}</td>
                    <td>Q. {{number_format($o->g_cli, 2)}}</td>
                    <td>Q. {{number_format($o->total, 2)}}</td>
                    <td>{{$o->descripcion}}</td>
                    <td></td>
                </tr>
                @endforeach

            </tbody>
        </table>

        <h5>DOCTOR: Q. {{number_format($t, 2)}} </h5>
        <h5>CLÍNICA: Q. {{number_format($t2, 2)}}</h5>
        <h5>TOTAL: Q. {{number_format($t3, 2)}} </h5>


        <button class="btn btn-info oculto-impresion" onclick="exportTableToExcel2('tblData', 'TRATAMIENTOS')">EXPORTAR TABLA</button>

    </div>
</div>


@endsection

@section('scripts')
<script>
    function exportTableToExcel2(tableID, filename) {
        // Tipo de exportación
        if (!filename) filename = 'excel_data.xls';
        let dataType = 'application/vnd.ms-excel';

        // Origen de los datos
        let tableSelect = document.getElementById(tableID);
        let tableHTML = tableSelect.outerHTML;

        // Crea el archivo descargable
        let blob = new Blob([tableHTML], {
            type: dataType
        });

        // Crea un enlace de descarga en el navegador
        if (window.navigator && window.navigator.msSaveOrOpenBlob) { // Descargar para IExplorer
            window.navigator.msSaveOrOpenBlob(blob, filename);
        } else { // Descargar para Chrome, Firefox, etc.
            let a = document.createElement("a");
            document.body.appendChild(a);
            a.style = "display: none";
            let csvUrl = URL.createObjectURL(blob);
            a.href = csvUrl;
            a.download = filename;
            a.click();
            URL.revokeObjectURL(a.href)
            a.remove();
        }
    }
</script>
@endsection