@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <p class="text-center text-uppercase h1">MOBILIARIO Y EQUIPO</p>

            <table class="table-sm">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>DESCRIPCIÓN</th>
                        <th>CANTIDAD </th>
                        <th>PRECIO</th>
                        <th>FECHA DE MANTENIMIENTO</th>
                        <th>FECHA DE REGISTRO</th>
                        <th>FECHA DE MODIFICACIÓN</th>

                    </tr>
                </thead>
                <tbody>
                    @php
                    $totalCapital = 0;
                    @endphp
                    @foreach($mobiliario as $mobi)
                    <tr>
                        <td class="text-uppercase">{{$mobi->mobiliario}}</td>
                        <td class="text-uppercase">{{$mobi->descripcion}}</td>
                        <td>{{$mobi->cantidad}}</td>
                        <td>Q. {{number_format($mobi->precio, 2)}}</td>
                        <td>{{$mobi->fecha_mantenimiento}}</td>
                        <td>{{$mobi->created_at}}</td>
                        <td>{{$mobi->updated_at}}</td>
                    </tr>
                    @php
                    $totalCapital += ($mobi->cantidad * $mobi->precio);
                    @endphp
                    @endforeach
                </tbody>
            </table>

            <p class="h4">TOTAL EN CAPITAL: <b> Q. {{number_format($totalCapital, 2)}} </b> </p>

        </div>
    </div>
</div>

@endsection