@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <p class="display-4 text-center">REGISTRO PARA LABORATORIOS</p>
                    <div class="table-responsive">
                        <table class="table" id="tabl">
                            <thead>
                                <tr>
                                    <th>Fecha</th>
                                    <th>Laboratorio</th>
                                    <th>Paciente</th>
                                    <th>Descripción de Pago</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                $total = 0;
                                @endphp
                                @foreach ($pacientes as $pl)
                                <tr>
                                    <td>{{$pl->created_at}}</td>
                                    <td>{{$pl->nombre}}</td>
                                    <td>{{$pl->paciente}}</td>
                                    <td>{{$pl->descripcion}}</td>
                                    @php
                                    $total += $pl->total;
                                    @endphp
                                    <td>Q. {{number_format($pl->total, 2)}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <p class="h2 text-center">TOTAL DEUDA: Q. {{number_format($total, 2)}}</p>
                    <button class="btn btn-info oculto-impresion" onclick="exportTableToExcel2('tabl', 'LABORATORIO')">EXPORTAR TABLA</button>
                </div>
            </div>
        </div>


    </div>
</div>

@endsection


@section('scripts')
<script>
    function exportTableToExcel2(tableID, filename) {
        // Tipo de exportación
        if (!filename) filename = 'excel_data.xls';
        let dataType = 'application/vnd.ms-excel';

        // Origen de los datos
        let tableSelect = document.getElementById(tableID);
        let tableHTML = tableSelect.outerHTML;

        // Crea el archivo descargable
        let blob = new Blob([tableHTML], {
            type: dataType
        });

        // Crea un enlace de descarga en el navegador
        if (window.navigator && window.navigator.msSaveOrOpenBlob) { // Descargar para IExplorer
            window.navigator.msSaveOrOpenBlob(blob, filename);
        } else { // Descargar para Chrome, Firefox, etc.
            let a = document.createElement("a");
            document.body.appendChild(a);
            a.style = "display: none";
            let csvUrl = URL.createObjectURL(blob);
            a.href = csvUrl;
            a.download = filename;
            a.click();
            URL.revokeObjectURL(a.href)
            a.remove();
        }
    }
</script>
@endsection