@extends('layouts.consentimientos')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection


@section('content')
<div class="container-fluid">
    <div class="row oculto-impresion">
        <div class="col">

            <div class="card">

                <div class="card-body">
                    <div class="card-title">REGISTRO DE PACIENTES EN LABORATORIO</div>
                    <form action="{{route('paciente.labpacienteStore')}}" method="post">
                        @csrf

                        <input type="hidden" name="paciente_id" value="{{$paciente_id}}">

                        <div class="form-group">
                            <label for="">LABORATORIO</label>
                            <select id="select" class="form-control" name="laboratorio_id">
                                <option value="">SELECCIONE SERVICIO</option>
                                @foreach ($laboratorios as $laboratorio)
                                <option value="{{$laboratorio->servicio_id}}_{{$laboratorio->laboratorio_id}}">{{$laboratorio->laboratorio}} / Servicio: {{$laboratorio->servicio}} Costo: {{$laboratorio->precio}}</option>
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="">PIEZA:</label>
                            <select class="form-control" name="pieza">
                                <@include('admin.pacientes.data.piezas')
                                    </select>
                        </div>

                        <div class="form-group">
                            <label for="">DESCRIPCIÓN / MAS DATOS:</label>
                            <textarea class="form-control" name="descripcion" rows="3"></textarea>
                        </div>



                        <button type="submit" class="btn btn-outline-success">GUARDAR</button>

                    </form>
                </div>
            </div>

        </div>
    </div>


    <div class="row">
        <div class="col">

            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Laboratorio</th>
                            <th>Descripcion de Pago</th>
                            <th>Total</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pacientes as $pl)
                        <tr>
                            <td>{{$pl->created_at}}</td>
                            <td>{{$pl->nombre}}</td>
                            <td>@php
                                echo $pl->descripcion;
                                @endphp</td>
                            <td>Q. {{number_format($pl->total, 2)}}</td>
                            <td>
                                <a class="btn btn-danger" href="{{route('paciente.pacienteDelete', ['id' => $pl->id])}}" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>
@endsection


@section('scripts')
<script src="{{asset('plugins/slim-select/slimselect.min.js') }}">
</script>
<script>
    setTimeout(function() {
        new SlimSelect({
            select: '#select',
            placeholder: 'Select Permissions',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300);
</script>
@endsection