@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <p class="text-center text-uppercase h1">INVENTARIO DE INSUMOS </p>


            <table class="table-sm" id="table_id" data-page-length="15">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Precio </th>
                        <th>Cantidad </th>
                        <th>Mínimo </th>
                        <th>Fecha Vencimiento </th>
                        <th>Factura </th>

                    </tr>
                </thead>
                <tbody>
                    @php
                    $totalInve = 0;
                    @endphp
                    @foreach($insumos as $insumo)
                    <tr>
                        <td>{{$insumo->nombre}}</td>
                        <td>Q. {{number_format($insumo->precio, 2)}}</td>
                        <td>{{$insumo->cantidad}}</td>
                        <td>{{$insumo->minimo}}</td>
                        <td>{{$insumo->fecha_vencimiento}}</td>
                        <td>{{$insumo->factura}}</td>
                    </tr>
                    @php
                    $totalInve += ($insumo->precio *$insumo->cantidad)
                    @endphp
                    @endforeach
                </tbody>
            </table>

            <p class="h4">TOTAL EN INVERSION: Q. <b>{{number_format($totalInve, 2)}}</b></p>


        </div>
    </div>
</div>

@endsection