@extends('layouts.consentimientos')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/morrisChart/morris.css')}}">
<script src="{{asset('plugins/morrisChart/jquery.min.js')}}"></script>
<script src="{{asset('plugins/morrisChart/raphael-min.js')}}"></script>
<script src="{{asset('plugins/morrisChart/morris.min.js')}}"></script>
@endsection

@section('content')

<form action="" method="get">

   <select name="mes" id="mes" class="form-control">
      <option value="">MES</option>
      <option value="01">ENERO</option>
      <option value="02">FEBRERO</option>
      <option value="03">MARZO</option>
      <option value="04">ABRIL</option>
      <option value="05">MAYO</option>
      <option value="06">JUNIO</option>
      <option value="07">JULIO</option>
      <option value="08">AGOSTO</option>
      <option value="09">SEPTIEMBRE</option>
      <option value="10">OCTUBRE</option>
      <option value="11">NOVIEMBRE</option>
      <option value="12">DICIEMBRE</option>
   </select>

   <button type="submit" class="btn btn-primary"><i class="fa fa-search" aria-hidden="true"></i></button>


</form>

<div class="row mt-2 mb-4">
   <div class="col-md-12">
      <div class="card">
         <div class="card-body">
            <h4 class="card-title text-center text-uppercase">{{$titulo}}</h4>
            <div id="myfirstchart"></div>
            <div id="myfirstchart2"></div>


            <table class="table" id="tblData">
               <thead>
                  <tr>
                     <th></th>
                     <th>TRATAMIENTO</th>
                     <th>REALIZADO</th>
                     <th>ESPERADO</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $i = 0; ?>
                  @foreach ($masVendidos as $mas)
                  <?php $i++; ?>
                  <tr>
                     <td>{{$i}}</td>
                     <td>{{$mas->nombre}}, {{$mas->descripcion}}</td>
                     <td>{{$mas->tratamiento_id}}</td>
                     <td>{{$mas->mes}}</td>
                  </tr>
                  @endforeach

               </tbody>
            </table>

            <button class="btn btn-info" onclick="exportarExcel()">EXPORTAR TABLA</button>
         </div>
      </div>
   </div>
</div>


@endsection

@section('scripts')

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.2/xlsx.full.min.js"></script>

<script>
   function exportarExcel() {
      var tabla = document.getElementById('tblData');
      var wb = XLSX.utils.table_to_book(tabla, {
         sheet: "Sheet1"
      });
      XLSX.writeFile(wb, "TRATAMIENTOS ESTADISTICO.xlsx");
   }
</script>
<script>
   new Morris.Donut({
      // ID of the element in which to draw the chart.
      element: 'myfirstchart',
      // Chart data records -- each entry in this array corresponds to a point on
      // the chart.
      data: [
         <?php
         foreach ($masVendidos as $mas) {
         ?> {
               label: <?php echo "'$mas->nombre'"; ?>,
               value: <?php echo $mas->tratamiento_id; ?>

            },
         <?php } ?>
      ],
      // The name of the data record attribute that contains x-values.
      // xkey: 'year',
      // A list of names of data record attributes that contain y-values.
      // ykeys: ['value'],
      // Labels for the ykeys -- will be displayed when you hover over the
      // chart.
      // labels: ['s'],
      // barColors: ['#B28DFF']
   });


   new Morris.Bar({
      // ID of the element in which to draw the chart.
      element: 'myfirstchart2',
      // Chart data records -- each entry in this array corresponds to a point on
      // the chart.
      data: [
         <?php
         foreach ($masVendidos as $mas) {
         ?> {
               y: <?php echo "'$mas->nombre'"; ?>,
               value: <?php echo $mas->tratamiento_id; ?>,
               mes: <?php echo $mas->mes; ?>,


            },
         <?php } ?>
      ],
      // The name of the data record attribute that contains x-values.
      xkey: 'y',
      // A list of names of data record attributes that contain y-values.
      ykeys: ['value', 'mes', ],
      // Labels for the ykeys -- will be displayed when you hover over the
      // chart.
      labels: ['Realizado', 'Esperado', ],
      barColors: ['#B28DFF', '#B15DF1']
   });
</script>
@endsection