@extends('layouts.consentimientos')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/morrisChart/morris.css')}}">
<script src="{{asset('plugins/morrisChart/jquery.min.js')}}"></script>
<script src="{{asset('plugins/morrisChart/raphael-min.js')}}"></script>
<script src="{{asset('plugins/morrisChart/morris.min.js')}}"></script>
@endsection

@section('content')

<form action="" method="get">

   <select name="mes" id="mes" class="form-control">
      <option value="">MES</option>
      <option value="01">ENERO</option>
      <option value="02">FEBRERO</option>
      <option value="03">MARZO</option>
      <option value="04">ABRIL</option>
      <option value="05">MAYO</option>
      <option value="06">JUNIO</option>
      <option value="07">JULIO</option>
      <option value="08">AGOSTO</option>
      <option value="09">SEPTIEMBRE</option>
      <option value="10">OCTUBRE</option>
      <option value="11">NOVIEMBRE</option>
      <option value="12">DICIEMBRE</option>
   </select>

   <button type="submit" class="btn btn-primary"><i class="fa fa-search" aria-hidden="true"></i></button>


</form>

<div class="row mt-2 mb-4">
   <div class="col-md-12">
      <div class="card">
         <div class="card-body">
            <h4 class="card-title text-center text-uppercase">{{$titulo}}</h4>
            <div id="myfirstchart"></div>
            <div id="myfirstchart2"></div>



            <button class="btn btn-info" onclick="exportTableToExcel2('tblData', 'TRATAMIENTOS')">EXPORTAR TABLA</button>
         </div>
      </div>
   </div>
</div>


@endsection

@section('scripts')

<script>
   


   function exportTableToExcel2(tableID, filename) {
      // Tipo de exportación
      if (!filename) filename = 'excel_data.xls';
      let dataType = 'application/vnd.ms-excel';

      // Origen de los datos
      let tableSelect = document.getElementById(tableID);
      let tableHTML = tableSelect.outerHTML;

      // Crea el archivo descargable
      let blob = new Blob([tableHTML], {
         type: dataType
      });

      // Crea un enlace de descarga en el navegador
      if (window.navigator && window.navigator.msSaveOrOpenBlob) { // Descargar para IExplorer
         window.navigator.msSaveOrOpenBlob(blob, filename);
      } else { // Descargar para Chrome, Firefox, etc.
         let a = document.createElement("a");
         document.body.appendChild(a);
         a.style = "display: none";
         let csvUrl = URL.createObjectURL(blob);
         a.href = csvUrl;
         a.download = filename;
         a.click();
         URL.revokeObjectURL(a.href)
         a.remove();
      }
   }
</script>

<script>
   new Morris.Donut({
      // ID of the element in which to draw the chart.
      element: 'myfirstchart',
      // Chart data records -- each entry in this array corresponds to a point on
      // the chart.
      data: [
         <?php
         foreach ($masVendidos as $mas) {
         ?> {
               label: <?php echo "'$mas->nombre'"; ?>,
               value: <?php echo $mas->tratamiento_id; ?>

            },
         <?php } ?>
      ],
      // The name of the data record attribute that contains x-values.
      // xkey: 'year',
      // A list of names of data record attributes that contain y-values.
      // ykeys: ['value'],
      // Labels for the ykeys -- will be displayed when you hover over the
      // chart.
      // labels: ['s'],
      // barColors: ['#B28DFF']
   });


   new Morris.Bar({
      // ID of the element in which to draw the chart.
      element: 'myfirstchart2',
      // Chart data records -- each entry in this array corresponds to a point on
      // the chart.
      data: [
         <?php
         foreach ($masVendidos as $mas) {
         ?> {
               y: <?php echo "'$mas->nombre'"; ?>,
               value: <?php echo $mas->tratamiento_id; ?>,
            },
         <?php } ?>
      ],
      // The name of the data record attribute that contains x-values.
      xkey: 'y',
      // A list of names of data record attributes that contain y-values.
      ykeys: ['value', ],
      // Labels for the ykeys -- will be displayed when you hover over the
      // chart.
      labels: ['Realizado' ],
      barColors: ['#B28DFF', '#B15DF1']
   });
</script>
@endsection