@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <p class="text-center h1 text-uppercase">doctor {{$doctore->nombre}}</p>

            <table class="table" id="table_id">
                <thead>
                    <tr>
                        <th>PACIENTE</th>
                        <th>FECHA DE REALIZACIÓN</th>
                        <th>TRATAMIENTO</th>
                        <!-- <th>TIPO</th> -->
                        <th>SUBTOTAL</th>
                        <th>RECOMENDACIÓN</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $trn = 0;
                    $descuentos2 = 0;
                    $total_pago2 = 0;
                    ?>
                    @foreach ($historial as $his)
                    <?php
                    $reco = getNotaToProcedimiento($doctore->id, $his->paciente_id, $his->tratamiento_id, $his->pieza)->recomendacion ?? 'N/A';
                    $pago = getPagoProcedimiento($doctore->id, $his->tratamiento_id);

                    $sub = (($pago->tratamiento->precio ?? 0)  * ($pago->porcentaje ?? 0) / 100) + ($pago->monto ?? 0);


                    if (!$reco) {
                        $descuentos2 += $sub;
                    }

                    $total_pago2 += $sub;

                    ?>
                    <tr>
                        <td>{{$his->nombre}}</td>
                        <td>{{$his->created_at}}</td>
                        <td>{{$his->tratamiento}} {{$his->descripcionTr}}</td>
                        <!-- <td>{{$his->tipo}}</td> -->
                        <td>Q. {{ number_format($sub, 2) }}

                            <!-- <br> {{$pago->porcentaje ?? 0}} - {{$pago->monto ?? 0}} -->
                        </td>
                        <td>{{$reco}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>


            <p class="h4">Descuentos</p>

            <div class="table-responsive">
                <table class="table table-hover" id="table_id2">
                    <thead>
                        <tr>
                            <th>DESCRIPCIÓN</th>
                            <th>VALOR</th>
                            <th>FECHA</th>

                        </tr>
                    </thead>
                    <tbody>
                        @php
                        $deuda = 0;
                        @endphp
                        @foreach ($descuentos as $d)
                        @php
                        $deuda += $d->valor;
                        @endphp
                        <tr>
                            <td>{{$d->descripcion}}</td>
                            <td>Q. {{number_format($d->valor, 2)}}</td>
                            <td>{{$d->created_at}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>


            <!-- <p class="my-2 h2 text-center">Total Ganancia de Tratamientos: Q. {{number_format($total_Pago, 2)}}</p>
            <p class="my-2 h2 text-center">Total Pacientes sin Recomendacion: Q. {{number_format($descuentos2, 2)}}</p>
            <p class="my-2 h2 text-center">Total Descuento: Q. {{number_format($deuda, 2)}}</p>
            <p class="my-2 h2 text-center">Total A Cancelar: Q. {{number_format($total_Pago - $deuda - $descuentos2, 2)}}</p> -->
            <p class="my-2 h2 text-center">Total A Cancelar: Q. {{number_format(round($total_pago2, 2), 2)}}</p>

        </div>
    </div>
</div>

@endsection

@section('scripts')
<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });

    $(document).ready(function() {
        var table = $("#table_id2").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>
@endsection