@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">
            <p class="text-center h2 text-uppercase">Descuento Doctor

                <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#descuentoDoctor">
                    NUEVO DESCUENTO
                </button>
            </p>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>DESCRIPCIÓN</th>
                            <th>VALOR</th>
                            <th>FECHA</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($data as $d)
                        <tr>
                            <td>{{$d->descripcion}}</td>
                            <td>Q. {{number_format($d->valor, 2)}}</td>
                            <td>{{$d->created_at}}</td>
                            <td>
                                <form action="{{route('des.delete', ['id' => $d->id])}}" method="post">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="descuentoDoctor" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">NUEVO DESCUENTO</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="{{route('des.store')}}" method="post">
                            @csrf
                            <div class="modal-body">

                                <input type="hidden" name="doctor_id" value="{{$doc->id}}">

                                <div class="form-group">
                                    <label for="">VALOR</label>
                                    <input type="number" step="any" class="form-control" name="valor">
                                </div>

                                <div class="form-group">
                                    <label for="">DESCRIPCIÓN</label>
                                    <textarea class="form-control" name="descripcion"></textarea>
                                </div>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
                                <button type="submit" class="btn btn-primary">GUARDAR</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>
@endsection