@extends('layouts.app')

@section('content')



<div class="container-fluid">
    <div class="row">
        <div class="col">
            <p class="text-center h2 text-uppercase">Doctores</p>
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="table_id" data-page-length="15">
                    <thead class="thead">
                        <tr>
                            <th>Nombre</th>
                            <th>Cantidad</th>

                            <th>Generado</th>
                            <th>% Aporte <br> Facturación</th>

                            <th>Comisiones</th>
                            <th>COM / TRAP</th>

                            <th>% Comisiones</th>
                            <th>Utilidad</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                        $total_cantidad = 0;
                        $total_generado_procedimientos = 0;
                        $total_comisiones = 0;
                        $total_utilidad = 0;
                        // este forear se coloco aca para poder calcula el total generado en la clinica antes de hacer el calculo de las comisiones
                        foreach ($doctores  as $doc) {
                            $generado_procedimientos = getTotalProcedimientosDoctor($doc->id, $mes, $anio);
                            $total_generado_procedimientos += $generado_procedimientos;
                        }

                        ?>

                        @foreach ($doctores as $doctore)
                        <tr>

                            <?php
                            $cantidad_tratmientos = cantidadTratamientosDoctor($doctore->id, $mes, $anio);
                            $generado_procedimientos = getTotalProcedimientosDoctor($doctore->id, $mes, $anio);
                            $total_cantidad += $cantidad_tratmientos;
                            $porcentaje_doctor = ($total_generado_procedimientos != 0) ? ($generado_procedimientos / $total_generado_procedimientos) * 100 : 0;

                            $comision = getPagoDoctor($doctore->id, $mes, $anio);
                            $total_comisiones += $comision;

                            $utilidad = ($generado_procedimientos - $comision);

                            $total_utilidad += $utilidad;


                            ?>

                            <td>{{ $doctore->nombre }}</td>
                            <td>{{$cantidad_tratmientos}}</td>

                            <td>Q. {{number_format($generado_procedimientos, 2)}} </td>
                            <td> {{number_format($porcentaje_doctor, 3)}} % </td>

                            <td>Q. {{number_format( $comision, 2)}} </td>
                            <!-- <td>com trat / pendiente (comisones dividido lo generado, eso es el porcentaje)</td> -->
                            <td> {{ number_format(($comision ?? 0 / $generado_procedimientos ?? 0) / 100, 2) }} % </td>

                            <!-- <td>% comisiones / pendiente (comision del doctos divido la suma de la columna)</td> -->

                            <td>{{ number_format( ($comision ?? 0 / $total_comisiones ?? 0) / 100, 2)  }} % </td>
                            <td>Q. {{number_format($utilidad, 2)}}</td>

                        </tr>
                        @endforeach

                        <tr>
                            <td>TOTAL</td>
                            <td>{{$total_cantidad}}</td>
                            <td>Q. {{number_format($total_generado_procedimientos, 2)}} </td>
                            <td>100%</td>
                            <td>Q. {{number_format($total_comisiones, 2)}}</td>
                            <td></td>
                            <td></td>
                            <td>Q. {{number_format($total_utilidad, 2)}}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


@endsection


@section('scripts')


<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>

@endsection