@extends('layouts.app')
@section('styles')

@endsection

@section('content')
<div class="container">
   <div class="row">
      <div class="col mb-4">
  
         <h3 class="text-center text-bold">CONSENTIMIENTO INFORMADO PARA PRÓTESIS FIJA</h3>

   
            <!-- relleno de datos -->
            <div class="form-inline">


               <p>Para la Clínica Odontológica SONRIEME es de suma importancia brindar a nuestros pacientes un servicio de
                  vanguardia dentro del campo odontológico guatemalteco. Le brindamos la más cordial bienvenida a Nuestra
                  Clínica, agradeciendo su confianza por preferirnos.
               </p> 

               <p>Usted tiene derecho a conocer el procedimiento al que va a ser sometido y las complicaciones más frecuentes
                  que ocurren. Este documento pretende explicarle lo descrito anteriormente, léalo atentamente y consulte:
                  todas las dudas que se le planteen. Le recordamos que por imperativo legal, tendrá que llenar y firmar con
                  su puño y letra, usted o su representante legal, el consentimiento informado para que pueda realizarle dicho
                  procedimiento.
               </p><br>

               <h5 style="margin: auto; font-size: 40px;">DECLARO</h5>

               <p class="d-inline">Que el (la) Dr.(a):
                  <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" placeholder="DOCTOR">

                  me ha explicado que es conveniente proceder por
                  mi situación dental, a la realización y colocación de una PRÓTESIS FIJA (CORONA Ó PUENTE) del diente/
                  molar, por lo que voluntariamente he solicitado de sus servicios dentales, para lo cual me han explicado lo
                  siguiente:
               </p>


               <p>
                  1. El propósito principal de la intervención es la reposición total o parcial de los dientes/molares ausentes o en
                  la reconstrucción anatómica de los dientes que hayan perdido estructura. <br><br>

                  2. La intervención puede ameritar el uso de anestesia local, de cuyos riesgos también se me ha informado. <br><br>

                  3. La intervención consiste en la preparación de la boca mediante el tallado de los dientes adyacentes (vecinos)
                  y el correcto manejo de los tejidos blandos (encía, piso de la boca, lengua, paladar blando, labios, etc.) y la
                  toma de impresión (reproducción de las estructuras orales) para realizar la reposición ordenada de los
                  dientes ausentes. <br><br>

                  4. Entiendo que en algunos Casos al momento de tallar los dientes puede haber exposición del nervio del
                  diente, de ser así, será necesario realizar un tratamiento de canales (retirar la pulpa o raíz enferma de un
                  diente y limpiar los canales, sellándolos al final). <br><br>

                  5.Entiendo que en algunos casos días o semanas después del tallado de los dientes puede aumentar
                  sensibilidad en los dientes, de ser así, también en estos casos podría ser necesario la aplicación de un
                  tratamiento de canales (retirar la pulpa o raíz enferma de un diente y limpiar los canales, sellándolos al final). <br><br>

                  6. Entiendo que a veces no es posible duplicar (conseguir) el color de un diente natural en un diente artificial.
                  Comprendo además que puedo tener que usar coronas temporarias (provisionales), las cuales pueden
                  desprenderse fácilmente, y que debo ser cuidadoso para garantizar que permanezcan fijas hasta que se me
                  entreguen las coronas permanentes. <br><br>

                  7. Me han explicado que el momento previo a la cementación (procédimierito,por el que se coloca de un
                  modo definitivo o provisional. una corona o un puente en los dientes preparados para recibirlo) será la última
                  oportunidad para realizar modificaciones en mi corona, puente o carillas nuevos (incluye forma, adaptación,
                  tamaño y color). <br><br>

                  8 Entiendo que los procedimientos cosméticos pueden afectar la superficie del diente y requerir modificaciones
                  en los procesos de higiene diaria (Tener buena higiene para evitar el enrojecimiento y sangrado en las
                  encías). <br><br>

                  9. Entiendo que es mi responsabilidad regresar para una cementación permanente en el tiempo que el (la)
                  Dr.(a) me indique. Demoras excesivas en la visita al dentista pueden causar caries, movimientos dentales,
                  enfermedades de encía o problemas de mordida. Esto puede requerir una nueva corona, puente o carilla.
                  Si esto último sucediera, entiendo que habrá gastos adicionales por la nueva corona, puente o carilla u otro
                  tratamiento debido a la demora en realizar la cementación permanente. <br><br>
               </p>

               <h5><b>RECOMENDACIONES</b></h5>
               <p>

                  - Los primeros días, procure cerrar la boca y masticar con cuidado para no morderse. <br>
                  - Evite comer alimentos duros como frutos secos con cáscara, huesos, chicharrones, etc. <br>
                  - Si se le ha cementado la prótesis provisionalmente, es recomendable masticar del otro lado, hacer una dieta
                  semiblanda, prestar atención a la retención de alimentos entre prótesis. <br>
                  - La limpieza se hará: en las partes accesibles, con cepillo dental y pasta dentífrica, entre la prótesis y la encía y entre los dientes con un hilo dental y accesorios indicados por el Odontólogo. <br>
                  - Es importante mantener una correcta higiene oral en el resto de los dientes, independientemente de la prótesis.
                  - Se debe realizar revisión cada seis meses para comprobar y corregir la aparición de caries, inflamación de encías,
                  movilidades dentarias y el estado y ajuste de la prótesis. <br> <br>
                  - Acudir a una consulta inmediata siempre que aparezcan ulceraciones, alguna anormalidad o movilidad de la
                  prótesis. <br>
               </p>

               <h5><b>RIESGOS PERSONALIZADOS</b></h5>
               <p class="d-inline">Además de los riesgos antes descritos, por mis circunstancias especiales hay que esperar los siguientes riesgos: <br>

                  <textarea class="form-control" cols="100" rows="2"></textarea>
                  <br>
                  He comprendido las explicaciones que se me han facilitado en un lenguaje claro y sencillo, y el Dr.(a) que me
                  ha atendido me ha permitido realizar todas las observaciones y me ha aclarado todas las dudas que le he
                  planteado.
                  También comprendo que, en cualquier momento y sin necesidad de dar ninguna explicación, puedo revocar
                  el consentimiento que ahora presto.
                  Por ello, manifiesto que estoy satisfecho con la información recibida y que comprendo el alcance y los riesgos
                  del tratamiento, y en tales condiciones,
               </p>
            </div>

            <!-- relelno de datos -->
            <hr>

            <h5 class="text-bold"> Consiento</h5>

            <p>Que se me realice el tratamientamiento colocación de una <b>PRÓTESIS FIJA</b></p>

            <!-- Paciente -->
            <div>
               <div class="form-inline">
                  <p class="d-inline">Nombre del Paciente:
                     <input type="hidden" name="paciente_id" value="{{$paciente->paciente_id}}">
                     <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->nombre}}">
                  </p>

                  <p class="d-inline ml-2">DPI del Paciente:
                     <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->dpi}} ">
                  </p>
               </div>

               <div class="row">
                  <div class="col text-center mb-5">
                     <div class="text-center" style="margin-top: 7%;">
                        @if ($paciente->firma)
                        <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                        @endif
                        _________________________________________ <br>
                        Firma
                     </div>
                  </div>
               </div>
            </div>
            <!-- fin paciente -->
            <hr>
            <!-- reprecentante legal -->
            <div>
               <div class="form-inline">

                  @if($paciente->dpi_en)
                  <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                     <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="dpi_en" value="{{$paciente->dpi_en}}">
                  </p>

                  <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                     <input style="width:220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="nombre_en" value="{{$paciente->nombre_en}}">
                  </p>
                  @else
                  <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                     <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_dpi" class="form-control" required>
                  </p>
                  <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                     <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_nombre" class="form-control" required>
                  </p>
                  @endif
               </div>

               <div class="row">
                  <div class="col text-center mb-5">
                     <div class="text-center" style="margin-top: 7%;">
                        @if ($paciente->firma)
                        <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                        @endif
                        _________________________________________ <br>
                        Firma
                     </div>
                  </div>
               </div>

            </div>
            <!-- fin reprecentante legal -->
            <hr>

            <!-- firma Doc / lugar y fecha-->
            <div>

               <div class="form-inline">
                  <p class="d-inline">Firma del Doctor:________________________________________________

                  </p>

                  <p class="d-inline ml-2">Lugar y Fecha:
                     <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="Huehuetenango zona 8,  {{$paciente->fecha}} " disabled>
                  </p>
               </div>


            </div>
            <!-- end firma doc / lugar y fecha  -->

          

      </div>
   </div>
</div>
@endsection