@extends('layouts.app')

@section('content')

<form action="{{route('pro.detailSave')}}" class="mb-4 mt-4">

    <div class="container-fuid">

        <div class="row p-4">
            <div class="col form-inline">


                <div class="form-group">
                    <label for="">PACIENTE:</label>
                    <input type="text" class="ml-2 form-control mb-2 mr-sm-2 text-uppercase" placeholder="{{$pac->nombre}} {{$pac->apellido}}" value="{{$pac->nombre}} {{$pac->apellido}}">
                </div>

                <div class="form-group ml-4">
                    <label for="">FECHA:</label>
                    <input type="date" class="ml-2 form-control" name="fecha" value="@isset($pro->fecha){{ $pro->fecha }}@endisset">
                </div>


                <div class="form-group ml-4">
                    <label for="">PIEZA:</label>
                    <input type="text" class="ml-2 form-control" name="pieza" placeholder="PIEZA" value=" @isset($pro->pieza){{ $pro->pieza }}@endisset">
                </div>

                <div class="form-group invisible">
                    <label for="">PACIENTE:</label>
                    <input type="text" class="ml-2 form-control" name="id_paciente" value="{{$pro->paciente_id}}">
                    <input type="text" class="ml-2 form-control" name="hoja" value="{{$pro->hoja}}">
                </div>

            </div>
        </div>

        <div class="row justify-content-around">

            <div class="col-3 border border-success mx-4 rounded">

                <p class="h5 text-success">HALLAZGOS SUBJETIVOS HISTORIAL DEL DIENTE</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="traumatismo" id="traumatismo" @isset($pro->traumatismo){{ 'checked' }}@endisset


                        >
                        <label class="form-check-label" for="traumatismo">
                            TRAUMATISMO
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="caries" id="caries" @isset($pro->caries){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="caries">
                            CARIES
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="cariosa" id="cariosa" @isset($pro->expocariosa){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="cariosa">
                            EXPOSICIÓN CARIOS
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="mecanica" id="mecanica" @isset($pro->expomecanica){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="mecanica">
                            EXPOSICIÓN MECÁNICA
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="deficiente" id="deficiente" @isset($pro->resdeficiente){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="deficiente">
                            RESTAURACIÓN DEFICIENTE
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="rpd" id="rpd" @isset($pro->rdp){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="rpd">
                            RPD
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="pulpotomia" id="pulpotomia" @isset($pro->pulpotomia){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="pulpotomia">
                            PULPOTOMIA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="pulpectomia" id="pulpectomia" @isset($pro->pulpectomia){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="pulpectomia">
                            PULPECTOMIA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="tcr" id="tcr" @isset($pro->tcr){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="tcr">
                            TCR
                        </label>
                    </div>
                </div>

                <p class="h5 text-success mt-4">NATURALEZA DEL DOLOR</p>
                <div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="docasintomatico" id="docasintomatico" @isset($pro->dolorAsintomatico){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="docasintomatico">
                            ASINTOMÁTICO
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="docespontaneo" id="docespontaneo" @isset($pro->dolorEspontaneo){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="docespontaneo">
                            ESPONTANEO
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="docprovocado" id="docprovocado" @isset($pro->dolorProvocado){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="docprovocado">
                            PROVOCADO
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="localizado" id="localizado" @isset($pro->dolorLocalizado){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="localizado">
                            LOCALIZADO
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="docdifuso" id="docdifuso" @isset($pro->dolorDifuso){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="docdifuso">
                            DIFUSO
                        </label>
                    </div>

                </div>

                <p class="h5 text-success mt-4">DURACION DEL DOLOR</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dolorcorto" id="dolorcorto" @isset($pro->dolorCorto){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dolorcorto">
                            CORTO
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dolorprolongado" id="dolorprolongado" @isset($pro->dolorProlongado){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dolorprolongado">
                            PROLONGADO
                        </label>
                    </div>
                </div>

                <p class="h5 text-success mt-4">EDEMA</p>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" value="true" name="edema" id="edema" @isset($pro->edema){{ 'checked' }}@endisset>
                    <label class="form-check-label" for="edema">
                        EDEMA
                    </label>
                </div>

            </div>

            <div class="col-3 border border-success mx-3">

                <p class="h5 text-success mt-4">SIGNOS OBJETIVOSY PRUEBAS TERMICA</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="termicaasintomatica" @isset($pro->pruebaAsintomatica){{ 'checked' }}@endisset id="termicaasintomatica">
                        <label class="form-check-label" for="termicaasintomatica">
                            ASINTOMÁTICA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="termicacorta" id="termicacorta" @isset($pro->pruebaCorta){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="termicacorta">
                            CORTA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="termicaprolongado" @isset($pro->pruebaprolongada){{ 'checked' }}@endisset id="termicaprolongado">
                        <label class="form-check-label" for="termicaprolongado">
                            PROLONGADA > 8 seg
                        </label>
                    </div>
                </div>

                <p class="h5 text-success mt-4">PALPACIÓN MUCOSA SUPERFICIAL</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="mucosaasintomatica" @isset($pro->mucosaAsintomatica){{ 'checked' }}@endisset id="mucosaasintomatica">
                        <label class="form-check-label" for="mucosaasintomatica">
                            ASINTOMATICA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="mucosasintomatica" @isset($pro->mucosaSintomatica){{ 'checked' }}@endisset id="mucosasintomatica">
                        <label class="form-check-label" for="mucosasintomatica">
                            SINTOMATICA
                        </label>
                    </div>
                </div>

                <p class="h5 text-success mt-4">PERCUSIÓN</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="percusionasintomatica" @isset($pro->percusionAsintomatica){{ 'checked' }}@endisset id="percusionasintomatica">
                        <label class="form-check-label" for="percusionasintomatica">
                            ASINTOMATICA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="percusionleve" id="percusionleve" @isset($pro->percusionLeve){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="percusionleve">
                            LEVE MODERADA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="percusionSevera" id="percusionSevera" @isset($pro->percusionSevera){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="percusionSevera">
                            SEVERA
                        </label>
                    </div>
                </div>

                <p class="h5 text-success mt-4">ESTADO PERIODONTAL</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="perionormal" id="perionormal" @isset($pro->estadoNormal){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="perionormal">
                            NORMAL
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="periomovilidad" id="periomovilidad" @isset($pro->estadoMovilidad){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="periomovilidad">
                            MOVILIDAD
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="periosignificativa" @isset($pro->estadoSignificativa){{ 'checked' }}@endisset id="periosignificativa">
                        <label class="form-check-label" for="periosignificativa">
                            PERIODONTITIS SIGNIFICATIVA
                        </label>
                    </div>
                </div>

                <p class="h5 text-success mt-4">FISTULA</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="fistulaAusente" id="fistulaAusente" @isset($pro->fistulaAusente){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="fistulaAusente">
                            AUSENTE
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="fistulaPresente" id="fistulaPresente" @isset($pro->fistulaPresente){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="fistulaPresente">
                            PRESENTE
                        </label>
                    </div>
                </div>

            </div>

            <div class="col-3 border border-success mx-3">

                <p class="h5 text-success mt-4">HALLAZGOS RADIOGRÁFICOS</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hnorma" id="hnorma" @isset($pro->rNormal){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hnorma">
                            NORMAL
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hlpd" id="hlpd" @isset($pro->lpd){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hlpd">
                            LPD ENSANCHADO
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hradiolucidezmax" id="hradiolucidezmax" @isset($pro->radiomax){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hradiolucidezmax">
                            RADIOLUCIDEZ > 10mm
                        </label>
                    </div>


                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hradiolucidesmin" id="hradiolucidesmin" @isset($pro->radiomin){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hradiolucidesmin"> RADIOLUCIDEZ < 10mm </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hapical" id="hapical" @isset($pro->curvatura){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hapical">
                            RADIOCAPACIDAD APICAL
                        </label>
                    </div>


                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hint" id="hint" @isset($pro->rInt){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hint">
                            RESORCION INT
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hext" id="hext" @isset($pro->rExt){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hext">
                            RESORCION EXT
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hdeficiente" id="hdeficiente" @isset($pro->obturacion){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hdeficiente">
                            OBTURACION DEFICIENTE
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hfractura" id="hfractura" @isset($pro->radicular){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hfractura">
                            FRACTURA RADICULAR
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hperforacion" id="hperforacion" @isset($pro->perforacion){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hperforacion">
                            PERFORACION
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hposte" id="hposte" @isset($pro->poste){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hposte">
                            POSTE
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hinstrumento" id="hinstrumento" @isset($pro->rfracturado){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hinstrumento">
                            INSTRUMENTO FRACTURADO
                        </label>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="hapice" id="hapice" @isset($pro->apiceinmaduro){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="hapice">
                            APICE INMADURO
                        </label>
                    </div>

                </div>

                <hr>

                <p class="h5 text-success mt-4">DX PULPAR</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxreversible" id="dxreversible" @isset($pro->preversible){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxreversible">
                            PULPITIS REVERSIBLE
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxirreversible" id="dxirreversible" @isset($pro->pirreversible){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxirreversible">
                            PULPITIS IRREVERSIBLE
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxnecrosis" id="dxnecrosis" @isset($pro->nrecosis){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxnecrosis">
                            NECROSIS
                        </label>
                    </div>
                </div>

                <p class="h5 text-success mt-4">DX PERIAPICAL</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxpaa" id="dxpaa" @isset($pro->paa){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxpaa">
                            PAA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxaaa" id="dxaaa" @isset($pro->aaa){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxaaa">
                            AAA
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxpac" id="dxpac" @isset($pro->pac){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxpac">
                            PAC
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxaac" id="dxaac" @isset($pro->aac){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxaac">
                            AAC
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxafenix" id="dxafenix" @isset($pro->afenix){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxafenix">
                            A FENIX
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="dxcondensante" id="dxcondensante" @isset($pro->osteitis){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="dxcondensante">
                            OSTEITIS CONDENSANTE
                        </label>
                    </div>
                </div>


            </div>

        </div>

        <div class="row">
            <div class="col m-4 border border-success">
                <p class="text-success h4">OBSERVACIONES INICIALES:</p>
                <textarea name="observacionesIniciales" class="form-control" cols="30" rows="5">@isset($pro->observaciones){{ $pro->observaciones  }}@endisset</textarea>

                <p class="h5 text-success mt-4">PRONOSTICO</p>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="pronosfavorable" id="pronosfavorable" @isset($pro->favorable){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="pronosfavorable">
                            FAVORABLE
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="true" name="pronosreservado" id="pronosreservado" @isset($pro->reservado){{ 'checked' }}@endisset>
                        <label class="form-check-label" for="pronosreservado">
                            RESERVADO
                        </label>
                    </div>
                </div>


            </div>
        </div>

    </div>

    <div class="container">
        <div class="row">
            <div class="col">

                <p class="text-success h4"> TX</p>
                <table class="table form-inline">
                    <tbody>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">CONDUCTOMETRIA: </label>
                                    <textarea name="conductometria" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->conductometria){{ $pro->conductometria }}@endisset
                                        </textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">LIMA ANATOMICA: </label>
                                    <textarea name="limaanatomica" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->lanatomica){{ $pro->lanatomica }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">LIMA MAESTRA: </label>
                                    <textarea name="limamaestra" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->lmaestra){{ $pro->lmaestra }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">CONO MAESTRO: </label>
                                    <textarea name="conomaestro" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->cmaestro){{ $pro->cmaestro }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">IRRIGANTE: </label>
                                    <textarea name="irrigante" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->irrigantes){{ $pro->irrigantes }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">SELLADOR: </label>
                                    <textarea name="sellador" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->sellador){{ $pro->sellador }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">MEDICACION INTRACONDUCTO: </label>
                                    <textarea name="medicintraconducto" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->medicamento){{ $pro->medicamento }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">ANTINFLAMATORIO: </label>
                                    <textarea name="antinflamatorio" class="ml-2 form-control w-100" cols="100" rows="1">@isset($pro->antinflamatorio){{ $pro->antinflamatorio }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="form-group">
                                    <label for="">ANTIBIOTERAPIA: </label>
                                    <textarea name="antibioterapia" class=" w-100 ml-2 form-control" cols="100" rows="1">@isset($pro->antibioterapia){{ $pro->antibioterapia }}@endisset</textarea>
                                </div>
                            </td>
                        </tr>

                    </tbody>
                </table>

            </div>
        </div>



        <div class="row">

            <div class="col-4 border border-success">

                <p class="h4 text-success">SX (SEGUIMIENTO)</p>
                <div class="form-inline">

                    <div class="form-group">
                        <label for="">1 MES: </label>
                        <textarea name="primermes" class=" w-100 ml-2 form-control" cols="30" rows="1">@isset($pro->mes1){{ $pro->mes1 }}@endisset</textarea>
                    </div>
                    <div class="form-group">
                        <label for="">3 MESES: </label>
                        <textarea name="tresmeses" class=" w-100 ml-2 form-control" cols="30" rows="1">@isset($pro->mes3){{ $pro->mes3 }}@endisset</textarea>
                    </div>
                    <div class="form-group">
                        <label for="">6 MESES: </label>
                        <textarea name="seismeses" class=" w-100 ml-2 form-control" cols="30" rows="1">@isset($pro->mes6){{ $pro->mes6 }}@endisset</textarea>
                    </div>

                </div>

            </div>

            <div class="col-8 border border-success">
                <p class="h4 text-success">CX (CPMPLICACIONES)</p>
                <div class="form-inline">

                    <div class="form-group">
                        <label for=""></label>
                        <textarea name="cx2" class=" w-100 ml-2 form-control" cols="70" rows="5">@isset($pro->cx){{ $pro->cx }}@endisset</textarea>
                    </div>


                </div>
            </div>
        </div>

        <div class="row">
            <div class="col my-4 border boder-success p-2">
                <p class="h4 text-success">TX COMPLEMENTARIOS</p>
                <div class="form-inline">


                    <textarea name="txcomplemetarios" class="ml-2 form-control" cols="300" rows="5">@isset($pro->complementarios){{ $pro->complementarios }}@endisset</textarea>


                </div>
            </div>
        </div>

    </div>


    <button type="submit" class="btn btn-success btn-lg m-4 oculto-impresion"><i class="fa fa-save"></i> GUARDAR</button>

</form>

<hr>

<form action="{{route('pro.historialSave')}}" method="get" class="mb-4 mt-4 d-none">
    <div class="container">

        <h4>HISTORIAL</h4>
        <div class="row">
            <div class="col">

                <div class="form-group invisible" style="display: none;">
                    <label for="">PACIENTE:</label>
                    <input type="text" class="ml-2 form-control" name="id_paciente" value="{{$pro->paciente_id}}">
                    <input type="text" class="ml-2 form-control" name="hoja" value="{{$pro->hoja}}">
                </div>

                <div class="form-group">
                    <label for="">TRATAMIENTO: </label>
                    <textarea name="tratamiento3" class=" w-100 ml-2 form-control" cols="100" rows="1"></textarea>
                </div>


                <div class="form-group">
                    <label for=""></label>
                    <select class="form-control text-uppercase" name="doc" required>
                        <option value="">SELECCIONE DOCTOR</option>
                        @foreach($doc as $d)
                        <option value="{{$d->nombre}}{{$d->apellido}}">{{$d->nombre}}{{$d->apellido}}</option>
                        @endforeach
                    </select>
                </div>


                <button type="submit" class="btn btn-outline-success btn-lg oculto-impresion"> <i class="fa fa-save    "></i> GUARDAR </button>
            </div>
        </div>
    </div>
</form>


<div class="container d-none">
    <div class="row">
        <div class="col">
            <table class="table table-hover  ">
                <thead class="thead-default">
                    <tr>
                        <th class="text-uppercase">Fecha</th>
                        <th class="text-uppercase">Tratmiento</th>
                        <th class="text-uppercase">Doctor</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($odonto as $o )
                    <tr>
                        <td scope="row" class="text-uppercase"> {{$o->fecha}}</td>
                        <td class="text-uppercase">{{$o->tratamiento}}</td>
                        <td class="text-uppercase">{{$o->doctor}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
</div>

@endsection