@extends('layouts.app')
@section('styles')
<style>
    p {
        text-align: justify;
    }

    img {
        display: block;
        margin: auto;
    }
</style>
@endsection

@section('content')

<div class="container">


    <div class="row">
        <div class="col my-4">

            <h4 class="text-center text-bold">CONSENTIMIENTO INFORMADO PARA EXTRACCIÓN DENTARIA</h4>


            @csrf

            <!-- relleno de datos -->
            <div class="form-inline">


                <p>
                    Para la Clínica Odontológica Sonrieme es de suma importancia brindar a nuestros pacientes un servicio de
                    vanguardia dentro del campo odontológico guatemalteco. Le brindamos la más cordial bienvenida a Nuestra
                    Clínica, agradeciendo su confianza por preferirnos.
                </p>


                <p>
                    Usted tiene derecho a conocer el procedimiento al que va a ser sometido y las complicaciones más frecuentes que
                    ocurren. Este documento pretende explicarle lo descrito anteriormente, léalo atentamente y consulte todas las
                    dudas que se le planteen. Le recordamos que por imperativo legal, tendrá que llenar y firmar con su puño y letra,
                    usted o su representante legal, el consentimiento informado para que pueda realizarle dicho procedimiento.
                </p>

            </div>

            <h5 style="margin: auto; font-size: 40px;">DECLARO</h5>

            <p class="d-inline">Que el (la) Dr.(a):
                <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" placeholder="DOCTOR">
                me ha explicado que es conveniente proceder por mi
                situación dental, a la realización y colocación de una EXTRACCIÓN del diente/molar, por lo que voluntariamente
                he solicitado de sus servicios dentales, para lo cual me han explicado lo siguiente:
            </p>

            <p>
                En consecuencia, comprendo que no mantendré ese diente/molar y, que, únicamente, podrá ser sustituido por
                una prótesis o implante dental.
            </p>

            <p>
                1. El propósito de la intervención es la extracción del diente/molar, ya que aunque podría recurrir a técnicas
                conservadoras como la periodoncia o la endodoncia, las descarto por el estado que presenta, y que hace
                imposible su conservación. <br><br>

                2. La intervención puede precisar de anestesia local, de cuyos riesgos también se me ha informado. <br><br>

                3. La intervención consiste »en la aplicación de un fórceps a la corona (pinza con que se extrae el diente), practicando
                la luxación con movimientos de lateralidad (movimiento que se hacen con la mano), de manera que pueda
                desprenderse fácilmente del alveolo (hueso que sostiene el diente) donde está insertada. <br><br>

                4. Aunque se me han realizado los medios diagnósticos que se han estimado precisos (radiografía), comprendo
                que es posible que el estado inflamatorio del diente/molar que se me va a extraer pueda producir un proceso
                infeccioso, que puede requerir tratamiento con antibióticos y/o antiinflamatorios, del mismo modo que en el
                curso del procedimiento puede producirse una hemorragia, que exigiría, para detenerla, la colocación en el
                alveolo de una gasa seca. <br>
                También sé que en el curso del procedimiento pueden producirse, aunque no es frecuente, la fractura de la
                corona o de la(s) raíces, heridas en la mucosa de la mejilla o en la lengua, inserción de la raíz en el seno
                maxilar, fractura del tabique interradial o de la tuberosidad, que no dependen de la forma o modo de practicarse
                la intervención, ni de su correcta realización, sino que son imprevisibles, en cuyo caso el (la) Dr. (a) tomará las
                medidas precisas y continuará con la extracción. <br><br>

                5. El/la Dr. (a) me ha explicado que todo acto quirúrgico lleva implícitas una serie de complicaciones comunes
                y potencialmente serias que podrían requerir tratamientos complementarios tanto médicos como quirúrgicos,
                y que por mi situación actual (diabetes, cardiopatía, hipe rtención, anemia, edad avanzada, obesidad) pueden
                aumentar riesgos y complicaciones. <br><br>

                He leído las instrucciones de manejo, cuidado y mantenimiento que me ha entregado el (la) Dr. (a) y he
                comprendido todas las explicaciones que se me han facilitado en lenguaje claro y sencillo.
                El (la) Dr. (a) que me ha atendido me ha permitido realizar todas las observaciones y me ha aclarado todas
                las dudas que le he planteado.
                También comprendo que, en cualquier momento y sin necesidad de dar ninguna explicación, puedo revocar
                el consentimiento que ahora presto.
                Por ello, manifiesto que estoy satisfecho con la información recibida y que comprendo el alcance y los riesgos
                del tratamiento, y en tales condiciones.

            </p>

            <!-- relelno de datos -->
            <hr>


            <h5 class="text-bold"> Consiento</h5>

            <p>Que se me realice el tratamiento la realización de una <b>EXTRACCIÓN DENTAL</b></p>



            <!-- Paciente -->
            <div>
                <div class="form-inline">
                    <p class="d-inline">Nombre del Paciente:
                        <input type="hidden" name="paciente_id" value="{{$paciente->paciente_id}}">
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->nombre}}">
                    </p>

                    <p class="d-inline ml-2">DPI del Paciente:
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->dpi}} ">
                    </p>
                </div>

                <div class="row">
                    <div class="col text-center mb-5">
                        <div class="text-center" style="margin-top: 7%;">
                            @if ($paciente->firma)
                            <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                            @endif
                            _________________________________________ <br>
                            Firma
                        </div>
                    </div>
                </div>
            </div>
            <!-- fin paciente -->
            <hr>
            <!-- reprecentante legal -->
            <div>
                <div class="form-inline">

                    @if($paciente->dpi_en)
                    <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="dpi_en" value="{{$paciente->dpi_en}}">
                    </p>

                    <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                        <input style="width:220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="nombre_en" value="{{$paciente->nombre_en}}">
                    </p>
                    @else
                    <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_dpi" class="form-control" required>
                    </p>
                    <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_nombre" class="form-control" required>
                    </p>
                    @endif
                </div>

                <div class="row">
                    <div class="col text-center mb-5">
                        <div class="text-center" style="margin-top: 7%;">
                            @if ($paciente->firma)
                            <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                            @endif
                            _________________________________________ <br>
                            Firma
                        </div>
                    </div>
                </div>

            </div>
            <!-- fin reprecentante legal -->
            <hr>

            <!-- firma Doc / lugar y fecha-->
            <div>

                <div class="form-inline">
                    <p class="d-inline">Firma del Doctor:________________________________________________

                    </p>

                    <p class="d-inline ml-2">Lugar y Fecha:
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="Huehuetenango zona 8,  {{$paciente->fecha}} " disabled>
                    </p>
                </div>


            </div>
            <!-- end firma doc / lugar y fecha  -->



        </div>
    </div>
</div>


@endsection