<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="{{ asset('assets/lte/plugins/fontawesome-free/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/lte/dist/css/adminlte.min.css')}}">
    <title>Acido </title>
</head>

<body class="mb-4">



    <div class="container-fluid">

        <div class="row">
            <div class="col-sm-6">
                @include('includes/alerta')
            </div><!-- /.col -->
        </div><!-- /.row -->

        <div class="row mt-4 shadow p-3 mb-5 rounded text-white h3" style="background-color: #6610f2;">
            <div class="col-9">
                PACIENTE: {{$paciente->nombre}} {{$paciente->apellido}}
            </div>
            <div class="col-3">
                Edad: {{$edad}}
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col p-4">
                <img src="{{asset('assets/images/001.jpg')}}" alt="" class="img-fluid">


                <div class="shadow p-3 mb-5 rounded text-white h3 text-center" style="background-color: #9C64F7;">ACIDO</div>




            </div>
        </div>


        <form action="{{route('este.acidoSave')}}" method="POST">
            @csrf
            <input type="hidden" value="{{$acido->id}}" name="id">
            <div class="row justify-content-center">



                <div class="col-2"></div>

                <div class="col-3">
                    <div class="form-group">
                        <label for="">Fecha de Aplicación</label>
                        <input type="date" class="form-control" name="fecha" value="@isset($acido->fecha){{ $acido->fecha }}@endisset">
                    </div>
                </div>



            </div>


            <div class="row justify-content-center">
                <div class="col-4 p-4">

                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="surco" value="@isset($acido->surco){{ $acido->surco }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">SURCO NASOGENIANO</label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="rino" value="@isset($acido->rino){{ $acido->rino }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">RINO MODELACIÓN</label>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="ceja" value="@isset($acido->cejas){{ $acido->cejas }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">CEJAS</label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="pomulo" value="@isset($acido->pomulo){{ $acido->pomulo }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">POMULO</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="menton" value="@isset($acido->menton){{ $acido->menton }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">MENTON</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="madi" value="@isset($acido->madibular){{ $acido->madibular }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">PERFILADO MANDIBULAR</label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="boca" value="@isset($acido->boca){{ $acido->boca }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">ANGULO DE LA BOCA</label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col form-inline">
                            <div class="form-group">
                                <input type="text" class="form-control" name="total" value="@isset($acido->total){{ $acido->total }}@endisset">
                                <label for="" class="ml-2 shadow-sm p-2 bg-light rounded">TOTAL DE ML <br>
                                    INYECTADOS</label>
                            </div>
                        </div>
                    </div>

                    <div class="col-4 form-inline mt-2">

                        <div class="form-group">
                            <label for="">OBSERVACIONES</label>
                            <textarea class="form-control ml-1" name="observaciones" rows="3" cols="50">@isset($acido->obsevaciones){{ $acido->obsevaciones }}@endisset</textarea>
                        </div>

                    </div>

                    <button type="submit" class="btn btn-success "> <i class="fa fa-save    "></i> GUARDAR</button>
                </div>
            </div>

        </form>

    </div>

    <!-- jQuery -->
    <script src="{{ asset('assets/lte/plugins/jquery/jquery.min.js') }}"></script>
    <!-- Bootstrap 4 -->
    <script src="{{ asset('assets/lte/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- AdminLTE App -->
    <script src="{{ asset('assets/lte/dist/js/adminlte.min.js') }}"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="{{ asset('assets/lte/dist/js/demo.js') }}"></script>


</body>

</html>