@extends('layouts.app')

@section('styles')
<style>
    p {
        text-align: justify;
    }

    img {
        display: block;
        margin: auto;
    }
</style>
@endsection

@section('content')
<div class="container">
    <div class="row">
        <div class="col mb-4">

            <h3 class="text-center text-bold">CONSENTIMIENTO INFORMADO PARA ENDODONCIA</h3>


            <!-- relleno de datos -->
            <div class="form-inline">


                <p>Para la Clínica Odontológica Sonrieme es de suma importancia brindar a nuestros pacientes un servicio de
                    vanguardia dentro del campo odontológico guatemalteco. Le brindamos la más cordial bienvenida a Nuestra
                    Clínica, agradeciendo su confianza por preferirnos.</p>

                <p>Usted tiene derecho a conocer el procedimiento al que va a ser sometido y las complicaciones más frecuentes
                    que ocurren. Este documento pretende explicarle lo descrito anteriormente, léalo atentamente y consulte
                    todas las dudas que se le planteen. Le recordamos que por imperativo legal, tendrá que llenar y firmar con
                    su puño y letra, usted o su representante legal, el consentimiento informado para que pueda realizarle dicho
                    procedimiento.</p>

                <h5 style="margin: auto; font-size: 40px;">DECLARO</h5>

                <p class="d-inline">Que el (la) Dr.(a):
                    <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" placeholder="DOCTOR">

                    me ha explicado que es conveniente proceder por
                    mi situación dental, a la realización de una ENDODONCIA (Tratamiento de Conductos) del diente/molar, por lo
                    que voluntariamente he solicitado de sus servicios dentales, para lo cual me han explicado lo siguiente:
                </p>


                <p>
                    1. La endodoncia o tratamiento de conducto, consiste en la extracción de la pulpa (en la raíz del diente), la cual
                    se trata de un tejido pequeño, que se encuentra en el centro del conducto del diente. La pulpa puede dañarse
                    (infectarse) o morir por un diente fracturado, por caries profundas y por lesiones, tales como golpes severos
                    en la raíz, recientes o pasados. Si la pulpa está infectada o muerta y no se extrae, se forma -un depósito de
                    pus en la punta de la raíz y se forma un absceso (acumulación de pus). Este aseso puede destruir el hueso
                    que rodea al diente y provocar dolor. Una vez extraída la pulpa dañada o muerta, el espacio que queda se
                    rellena con un material que sella la cavidad (agujero) y evita el paso de bacterias y toxinas, conservando de
                    esta manera el diente o muela. Años atrás, los dientes con raíces dañadas o enfermas se extraían, pero en la
                    actualidad la pieza dental con este tratamiento de conducto, se salva. <br><br>


                    2. El propósito principal de la endodoncia es la eliminación del tejido pulpar (raíz del diente) inflamado o
                    infectado. <br><br>

                    3. La endodoncia necesita la aplicación de anestesia local, con el fin de realizar el procedimiento sin dolor.
                    Me han explicado que la administración de la anestesia en el punto donde se administra la inyección, puede
                    provocar ulceración (llaga) de la mucosa y dolor; menos frecuentemente puede provocar una limitación en
                    el movimiento de abrir la boca, lo cual puede requerir tratamiento después. Me ha explicado que después de
                    la aplicación de la anestesia, voy a sentir una sensación de entumecimiento del labio o de la cara y que esto
                    va a desaparecer en 2 o 3 horas. Estoy enterado (a) que la anestesia puede provocar bajada de la presión
                    arterial. <br><br>

                    4. He sido informado que durante la desinfección del conducto radicular con los irrigantes (Hipoclorito de
                    Sodio), podría presentar dolor y/o aumento de volumen. Ya que podría existir un contacto con los tejidos
                    circundantes a la raíz, en cuyo caso se tomarán las medidas necesarias para aliviar la molestia. <br><br>

                    5. He sido informado que, a pesar de realizarse correctamente la técnica, cabe la posibilidad de que la infección
                    no se elimine totalmente, pudiendo ser necesario un re-tratamiento, como también pudiese presentar dolor
                    y/o aumento de volumen posterior al procedimiento. <br><br>


                <p class="d-inline">
                    7. Me han explicado que la endodoncia como acto quirúrgico lleva contenida una serie de complicaciones comunes y potencialmente serias, llevando incluso a la indicación de extracción <br>
                    <textarea class="form-control" cols="100" rows="2"></textarea>
                </p>



                </p>

            </div>

            <!-- relelno de datos -->
            <hr>

            <h5 class="text-bold"> Consiento</h5>

            <p>Que se me realice una <b>ENDODONCIA.</b></p>

            <!-- Paciente -->
            <div>
                <div class="form-inline">
                    <p class="d-inline">Nombre del Paciente:
                        <input type="hidden" name="paciente_id" value="{{$paciente->paciente_id}}">
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->nombre}}">
                    </p>

                    <p class="d-inline ml-2">DPI del Paciente:
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->dpi}} ">
                    </p>
                </div>

                <div class="row">
                    <div class="col text-center mb-5">
                        <div class="text-center" style="margin-top: 7%;">
                            @if ($paciente->firma)
                            <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                            @endif
                            _________________________________________ <br>
                            Firma
                        </div>
                    </div>
                </div>
            </div>
            <!-- fin paciente -->
            <hr>
            <!-- reprecentante legal -->
            <div>
                <div class="form-inline">

                    @if($paciente->dpi_en)
                    <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="dpi_en" value="{{$paciente->dpi_en}}">
                    </p>

                    <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                        <input style="width:220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="nombre_en" value="{{$paciente->nombre_en}}">
                    </p>
                    @else
                    <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_dpi" class="form-control" required>
                    </p>
                    <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_nombre" class="form-control" required>
                    </p>
                    @endif
                </div>

                <div class="row">
                    <div class="col text-center mb-5">
                        <div class="text-center" style="margin-top: 7%;">
                            @if ($paciente->firma)
                            <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                            @endif
                            _________________________________________ <br>
                            Firma
                        </div>
                    </div>
                </div>

            </div>
            <!-- fin reprecentante legal -->
            <hr>

            <!-- firma Doc / lugar y fecha-->
            <div>

                <div class="form-inline">
                    <p class="d-inline">Firma del Doctor:________________________________________________

                    </p>

                    <p class="d-inline ml-2">Lugar y Fecha:
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="Huehuetenango zona 8,  {{$paciente->fecha}} " disabled>
                    </p>
                </div>


            </div>


        </div>
    </div>
</div>
@endsection