@extends('layouts.app')

@section('styles')
<style>
    p {
        text-align: justify;
    }

    img {
        display: block;
        margin: auto;
    }
</style>
@endsection


@section('content')

<div class="container">



    <div class="row">
        <div class="col mt-4 mb-4">

            <h4 class="text-center text-bold">CONSENTIMIENTO INFORMADO PARA APLICACIÓN DE ANESTESIA LOCAL</h4>



            <!-- relleno de datos -->
            <div class="form-inline">


                <p>Para la Clínica Odontológica Sonrieme es de suma importancia brindar a nuestros pacientes un servicio de
                    vanguardia dentro del campo odontológico guatemalteco. Le brindamos la más cordial bienvenida a Nuestra
                    Clínica, agradeciendo su confianza por preferirnos.</p>

                <p>Usted tiene derecho a conocer el procedimiento al que va a ser sometido y las complicaciones más frecuentes
                    que ocurren. Este documento pretende explicarle lo descrito anteriormente, léalo atentamente y consulte
                    todas las dudas que se le planteen. Le recordamos que por imperativo legal, tendrá que llenar y firmar con
                    su puño y letra, usted o su representante legal, el consentimiento informado para que pueda realizarle dicho
                    procedimiento.</p>

                <p style="margin: auto; font-size: 20px;">DECLARO</p>

                <p class="d-inline">Que el (la) Dr.(a):
                    <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" placeholder="DOCTOR">

                    me ha explicado que el tratamiento odontológico
                    que necesito implica la administración de ANESTESIA LOCAL, Al respecto entiendo que:
                </p>


                <p>
                    1. La anestesia local se utiliza en Odontología con la finalidad de procurar efectuar el tratamiento odontológico
                    sin dolor. <br>

                    2. La anestesia local se aplica mediante una inyección de sustancias, que bloquean de manera reversible
                    (temporalmente) los impulsos nerviosos de modo tal que se interrumpe transitoriamente (momentáneamente)
                    la sensibilidad. <br>

                    3. El efecto de la anestesia local me producirá una sensación extraña en la región anestesiada, que normalmente
                    desaparecerá espontáneamente en dos o tres horas. <br>
                    4. La administración de la anestesia local puede provocar en alguno casos: úlceras en la mucosa, dolor;
                    hematoma (acumulación de sangre, causado por la rotura de vasos capilares) y, en algunas ocasiones
                    limitaciones en el movimiento de apertura de la boca, que pueden requerir tratamiento ulterior. Del mismo
                    modo, puede ocasionar una baja de presión y sensación de mareo. <br>

                    5. Entiendo que algunos pacientes pueden presentar algún tipo de reacción alérgica o hipersensibilidad
                    (reacción del organismo que se produce como rechazo a una sustancia que le afecta negativamente de
                    modo anormal). <br>

                    6. Puedo también presentar alergia a la anestesia local, que se manifiesta como urticaria (enfermedad de la
                    piel que se manifiesta por picazón y manchas rojas), dermatitis de contacto (Proceso inflamatorio de la piel), asma y edema angioneurótico (inflamación similar a la urticaria, sólo que es debajo de la piel en
                    lugar de en la superficie) que en casos extremos pueden requerir tratamiento de emergencia. Sin embargo,
                    según se me ha explicado, en base a mis antecedentes personales no es de esperar para mi caso este tipo
                    de reacciones desfavorables. <br>
                    7. Todo acto quirúrgico puede ocasionar potencialmente distintas complicaciones comunes y potencialmente
                    serias que podrían requerir tratamientos complementarios tanto médicos como quirúrgicos, sobre todo
                    en personas con alguna condición o enfermedad sistemática como las siguientes: diabetes (aumento de la
                    concentración de azúcar en la sangre), cardiopatía (enfermedades del corazón), hipertensión (presión
                    arterial alta), anemia, edad avanzada, obesidad, malnutrición. <br>


                    He comprendido las explicaciones que se me han facilitado en un lenguaje claro y sencillo, y el (la) Dr.(a) que
                    me ha atendido me ha permitido realizar toda las observaciones y me ha aclarado todas las dudas que le
                    he planteado. También comprendo que, en cualquier momento y sin necesidad de dar ninguna explicación,
                    puedo revocar el consentimiento que ahora presto.

                </p>

            </div>

            <!-- relelno de datos -->
            <hr>

            <h5 class="text-bold"> Consiento</h5>

            <p>La aplicación de <b>ANESTESIA LOCAL.</b></p>

            <!-- Paciente -->
            <div>
                <div class="form-inline">
                    <p class="d-inline">Nombre del Paciente:
                        <input type="hidden" name="paciente_id" value="{{$paciente->paciente_id}}">
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->nombre}}">
                    </p>

                    <p class="d-inline ml-2">DPI del Paciente:
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{$paciente->dpi}} ">
                    </p>
                </div>

                <div class="row">
                    <div class="col text-center mb-5">
                        <div class="text-center" style="margin-top: 7%;">
                            @if ($paciente->firma)
                            <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                            @endif
                            _________________________________________ <br>
                            Firma
                        </div>
                    </div>
                </div>
            </div>
            <!-- fin paciente -->
            <hr>
            <!-- reprecentante legal -->
            <div>
                <div class="form-inline">

                    @if($paciente->dpi_en)
                    <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="dpi_en" value="{{$paciente->dpi_en}}">
                    </p>

                    <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                        <input style="width:220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" name="nombre_en" value="{{$paciente->nombre_en}}">
                    </p>
                    @else
                    <p class="d-inline ml-2">DPI Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_dpi" class="form-control" required>
                    </p>
                    <p class="d-inline ml-2">Nombre Representante Legal / Familiar :
                        <input style="width: 220px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" name="rep_nombre" class="form-control" required>
                    </p>
                    @endif
                </div>

                <div class="row">
                    <div class="col text-center mb-5">
                        <div class="text-center" style="margin-top: 7%;">
                            @if ($paciente->firma)
                            <img src=" {{config('app.url')}}{{Storage::url('paciente/firmas/'.$paciente->firma)}}" alt="{{config('app.name')}}" style="width: 25%;"><br>
                            @endif
                            _________________________________________ <br>
                            Firma
                        </div>
                    </div>
                </div>

            </div>
            <!-- fin reprecentante legal -->

            <hr>

            <!-- firma Doc / lugar y fecha-->
            <div>

                <div class="form-inline">
                    <p class="d-inline">Firma del Doctor:________________________________________________

                    </p>

                    <p class="d-inline ml-2">Lugar y Fecha:
                        <input style="width: 320px; border-top: 0;border-left: 0;border-right: 0; border-bottom: 1px solid black;" type="text" class="form-control" value="{{config('app.direccion')}} - {{date('d - m - Y')}}" disabled>
                    </p>
                </div>


            </div>

        </div>
    </div>
</div>


@endsection