@extends('layouts.app')

@section('content')

<div class="container-fluid">

    <p class="display-4 text-center">DATOS DEL DIA {{$fecha}}</p>

    <div class="row">
        <div class="col-md-6">
            <div class="table-responsive">
                <h4 class="text-center display-5">PACIENTES OPERADOS</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>PACIENTE</th>
                            <th>TRATAMIENTO</th>
                            <th>TIPO</th>
                            <th>DOCTOR</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($pagos as $pago)
                        <tr>
                            <td>{{$pago->paciente->nombre}}</td>
                            <td>{{$pago->tratamiento->nombre}}</td>
                            <td>{{$pago->tratamiento->tipo}}</td>
                            <td>{{$pago->doctor->nombre}}</td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>

        <div class="col-md-6">
            <div class="table-responsive">
                <h4 class="text-center display-5">PACIENTES QUE ABONARON</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>PACIENTE</th>
                            <th>DESCRIPCION</th>
                            <th>TIPO</th>
                            <th>FACTURA</th>
                            <th>VALOR</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($h_abonos as $abo)
                        <tr>
                            <td>{{$abo->paciente->nombre}}</td>
                            <td>{{$abo->descripcion}}</td>
                            <td>{{$abo->tipo}}</td>
                            <td>{{$abo->factura}}</td>
                            <td>Q. {{number_format($abo->valor + $abo->incremento, 2)}}</td>
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col">
            <h4 class="display-5 text-center">ABONOS</h4>
            <h4>Efectivo: Q. {{number_format($abonos[0], 2)}} </h4>
            <h4>Visas: Q. {{number_format($abonos[1], 2)}} </h4>
            <h4>Transferencias: Q. {{number_format($abonos[2], 2)}}</h4>
            <h4>Depósitos: Q. {{number_format($abonos[3], 2)}}</h4>
            <h4>Otros: Q. {{number_format($abonos[4], 2)}} </h4>
            <hr>

        </div>
    </div>

    <div class="row my-5">
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <p class="display-5 text-center">REGISTRO PARA LABORATORIOS</p>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Fecha</th>
                                    <th>Laboratorio</th>
                                    <th>Paciente</th>
                                    <th>Descripción de Pago</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $tl = 0; ?>
                                @foreach ($laboratorios as $pl)
                                <?php $tl += $pl->total; ?>
                                <tr>
                                    <td>{{$pl->created_at}}</td>
                                    <td>{{$pl->nombre}}</td>
                                    <td>{{$pl->paciente}}</td>
                                    <td>{{$pl->descripcion}}</td>
                                    <td>{{$pl->total}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="h5 text-center">TOTAL EN LABORATORIOS: Q. {{number_format($tl, 2)}}</div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col">
            <h4 class="display-5 text-center">VENTAS</h4>

            <div class="row my-4">
                <div class="col">
                    <table class="table table-hover" id="deudas" data-page-length="15">
                        <thead>
                            <tr>
                                <th>No. Recibo</th>
                                <th>Articulo </th>
                                <th>Precio Venta</th>
                                <th>Precio Costo</th>
                                <th>Utilidad / Unitaria</th>
                                <th>Cantidad Vendida</th>
                                <th>Descuento</th>
                                <th>Total Con Descuento</th>
                                <th>Ganancia</th>
                                <th>Fecha / Hora de Venta</th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php

                            $utilidad = 0;
                            $descuentos = 0;
                            $totalVentasS = 0;

                            ?>
                            @foreach($ventas as $deu)
                            <?php
                            $totalVentasS = ($deu->p_venta *  $deu->cantidad) + $totalVentasS;
                            ?>
                            <tr>
                                <td>{{$deu->factura_id}}</td>
                                <td>{{$deu->nomArt}} / {{$deu->descripcion}}</td>
                                <td>Q. {{number_format($deu->p_venta, 2)}}</td>
                                <td>Q. {{number_format($deu->p_costo, 2)}}</td>
                                <td>Q. {{number_format($deu->p_venta - $deu->p_costo, 2)}}</td>
                                <td>{{$deu->cantidad}}</td>
                                <td>
                                    <?php
                                    $descuentos = $deu->descuento + $descuentos;
                                    ?>
                                    {{number_format($deu->descuento, 2)}}
                                </td>


                                <td>Q. {{($deu->p_venta ) * $deu->cantidad - ($deu->descuento)}}</td>

                                <?php

                                $utilidad = (($deu->p_venta * $deu->cantidad) - ($deu->p_costo * $deu->cantidad)) - $deu->descuento + $utilidad;

                                ?>

                                <td>Q. {{ (($deu->p_venta * $deu->cantidad ) - ($deu->p_costo * $deu->cantidad)) - $deu->descuento}} </td>

                                <td>{{$deu->fechaVenta}}</td>

                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>

            <div class="row" style="text-align: right;">
                <div class="col">
                    <p>Total en Ventas (esperadas) :</p> Q. {{ $totalVentasS }}
                    <p>Total en Ventas - Descuentos - Deuda de Medicamentos :</p> Q. {{ ($totalVentasS -  $descuentos) - $deudaMedicamento }}
                    <p>Total en Descuentos :</p> Q. {{ $descuentos      }}
                    <p>Ganancias :</p> Q. {{$utilidad}}

                    </p>
                </div>
            </div>
            <hr>

        </div>
    </div>


    <div class="row">

        <div class="col-md-6">
            <h4 class="display-5 text-center">CAJA CHICA</h4>
            <table class="table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Valor</th>
                        <th>Descripción</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                    $total = 0;
                    @endphp
                    @foreach ($entradas as $dt)
                    <tr>
                        <td scope="row">{{$dt->fecha}}</td>
                        <td>Q. {{number_format($dt->valor, 2)}}</td>
                        <td>{{$dt->descripcion}}</td>
                    </tr>

                    @php
                    $total += $dt->valor;
                    @endphp
                    @endforeach

                </tbody>
            </table>

            <h4>Total: Q. {{number_format($total, 2)}}</h4>
        </div>

        <div class="col-md-6">
            <h4 class="display-5 text-center">GASTOS</h4>

            <table class="table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Valor</th>
                        <th>Descripción</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                    $total2 = 0;
                    @endphp
                    @foreach ($salidas as $dt)
                    <tr>
                        <td scope="row">{{$dt->fecha}}</td>
                        <td>Q. {{number_format($dt->valor, 2)}}</td>
                        <td>{{$dt->descripcion}}</td>
                    </tr>

                    @php
                    $total2 += $dt->valor;
                    @endphp
                    @endforeach

                </tbody>
            </table>

            <h4>Total: Q. {{number_format($total2, 2)}}</h4>
        </div>

    </div>

    <div class="row mt-5">
        <div class="col">
            <h4 class="text-center">ORTODONCIA</h4>
            <table class="table">
                <thead>
                    <tr>
                        <th>PACIENTE</th>
                        <th>DOCTOR</th>
                        <th>G. DOCTOR</th>
                        <th>CLÍNICA</th>
                        <th>TOTAL</th>
                        <th></th>

                    </tr>
                </thead>
                <tbody>
                    <?php $t = 0;
                    $t2 = 0;
                    $t3 = 0; ?>

                    @foreach ($orto as $o)

                    <?php
                    $t += $o->g_doc;
                    $t2 += $o->g_cli;
                    $t3 += $o->total;
                    ?>
                    <tr>
                        <td>{{$o->paciente}} </td>
                        <td>{{$o->doctor->nombre}}</td>
                        <td>Q. {{number_format($o->g_doc, 2)}}</td>
                        <td>Q. {{number_format($o->g_cli, 2)}}</td>
                        <td>Q. {{number_format($o->total, 2)}}</td>
                        <td>
                            <form action="{{route('orto.delete', $o->id)}}" method="post">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></button>
                            </form>
                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>


        </div>
    </div>

    <div class="row">
        <div class="col">
            <div class="table-responsive">
                <div class="h3 text-center">DESCUENTOS DE PAGO</div>
                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>DESCRIPCIÓN</th>
                            <th>VALOR</th>
                            <th></th>

                        </tr>
                    </thead>
                    <tbody>
                        <?php $td = 0; ?>
                        @foreach ($salidas_orto as $S)
                        <?php $td += $S->valor; ?>
                        <tr>
                            <td>{{$S->id}}</td>
                            <td>{{$S->descripcion}}</td>
                            <td>Q. {{number_format($S->valor, 2)}}</td>
                            <td>
                                <a onclick="return confirm('Esta Seguro de Eliminar?')" class="btn btn-danger" href="" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <h5>DOCTOR: Q. {{number_format($t, 2)}} </h5>
    <h5>CLINICA: Q. {{number_format($t2, 2)}}</h5>

    <h5>TOTAL EN DESCUENTOS: Q.{{number_format($td, 2)}}</h5>

    <h5>TOTAL: Q. {{number_format($t3 - $td, 2)}} </h5>


    <div class="row mb-5 mt-5 pb-5 justify-content-center">
        <div class="col-md-6">
            <p class="h3 text-center">Total De Pagos a Doctores : Q {{number_format($total_pago_doctors + $t - $td, 2)}}</p>
        </div>
    </div>




</div>


@endsection