@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <h1 class="display-4 text-center">REPORTE DE ENTRADAS</h1>
            <button class="btn btn-info" onclick="exportarExcel()">EXPORTAR TABLA EXCEL </button>

            <table class="table" id="table">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Valor</th>
                        <th>Descripción</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($data as $dt)
                    <tr>
                        <td scope="row">{{$dt->fecha}}</td>
                        <td>Q. {{number_format($dt->valor, 2)}}</td>
                        <td>{{$dt->descripcion}}</td>
                    </tr>
                    @endforeach

                </tbody>
            </table>

            <h4>Total: Q. {{number_format($total, 2)}}</h4>


        </div>
    </div>
</div>


@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.2/xlsx.full.min.js"></script>

<script>
    function exportarExcel() {
        var tabla = document.getElementById('table');
        var wb = XLSX.utils.table_to_book(tabla, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, "Caja Chica.xlsx");
    }
</script>

@endsection