@extends('layouts.app')
@section('content')

<div class="row">
    <div class="col">
        @include('includes.alerts')
    </div>
</div>

<div class="container-fluid p-3">
    <div class="row">
        <div class="col mt-4">
            <h4 class="text-center display-4">CUADRES CLÍNICA </h4>
        </div>
    </div>
    <div class="row my-4">
        <div class="col">
            <table class="table table-hover" id="cauadres" data-page-length="31">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Entradas </th>
                        <th>Salidas</th>
                        <th>Total A Cuadrar</th>
                        <th>Total en Efectivo</th>
                        <th>Total en Visas</th>
                        <th>Deuda Medicamentos</th>
                        <th>Abonado</th>
                        <th>Esperado</th>
                        <th>Faltante</th>
                        <th>Acciones</th>

                    </tr>
                </thead>
                <tbody>
                    @php
                    $totalMes = 0;
                    @endphp
                    @foreach($cuadres as $cau)
                    <tr>
                        <td>{{$cau->created_at}}</td>
                        <td>Q. {{number_format($cau->entrada, 2)}}</td>
                        <td>Q. {{number_format($cau->salida, 2)}}</td>
                        <td>Q. {{number_format($cau->cuadre, 2)}}</td>
                        <td>Q. {{number_format($cau->totalEfectico, 2)}}</td>
                        <td>Q. {{number_format($cau->totalVisas, 2)}}</td>
                        <td>Q. {{number_format($cau->deuda_medicamento, 2)}}</td>
                        <td>Q. {{number_format(sumAbonosToDate($cau->created_at), 2)}}</td>
                        <td>Q. {{number_format(subProcedimientoToDate($cau->created_at), 2)}}</td>
                        <td>Q. {{number_format($cau->faltante, 2)}}</td>
                        <td>
                            @php
                            $aux = explode(" ", $cau->created_at);
                            $totalMes += $cau->cuadre;
                            @endphp


                            @can('caja_movimientos_dia')
                            <a href="{{route('caja.cuadreFecha', [ 'fecha' => $aux[0] ] )}}" class="btn btn-sm btn-info"> <i class="fa fa-eye" aria-hidden="true"></i></a>
                            @endcan

                            @can('caja_cuadre_delete')
                            <a href="{{route('caja.deleteCuadre', [ 'id' => $cau->id ] )}}" class="btn btn-sm btn-danger" onclick="return confirm('¿Esta Seguro de Eliminar?')"> <i class="fa fa-trash" aria-hidden="true"></i></a>
                            @endcan
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>


            <h4>TOTAL EN CUADRES CLINICA: Q. {{number_format($totalMes,2)}}</h4>

            <button class="btn btn-info oculto-impresion" onclick="exportarExcel()">EXPORTAR TABLA</button>


        </div>
    </div>

    <div class="row my-4">
        <div class="col">
            <h4 class="text-center display-4">CUADRES MEDICAMENTO </h4>

            <table class="table table-hover" id="cauadres2" data-page-length="31">
                <thead>
                    <tr>
                        <th>Fecha</th>

                        <th>Total A Cuadrar</th>
                        <th>Total en Efectivo</th>
                        <th>Total en Visas</th>
                        <th>Deuda Medicamentos</th>
                        <th>Faltante</th>

                    </tr>
                </thead>
                <tbody>
                    @php
                    $totalMes = 0;
                    @endphp
                    @foreach($cuadreMedicamento as $cau)
                    <tr>
                        <td>{{$cau->created_at}}</td>

                        <td>Q. {{number_format($cau->cuadre, 2)}}</td>
                        <td>Q. {{number_format($cau->totalEfectico, 2)}}</td>
                        <td>Q. {{number_format($cau->totalVisas, 2)}}</td>
                        <td>Q. {{number_format($cau->deuda_medicamento, 2)}}</td>
                        <td>Q. {{number_format($cau->faltante, 2)}}</td>

                        @php
                        $aux = explode(" ", $cau->created_at);
                        $totalMes += $cau->cuadre;
                        @endphp

                    </tr>
                    @endforeach
                </tbody>
            </table>
            <h4>TOTAL EN CUADRES MEDICAMENTO: Q. {{number_format($totalMes,2)}}</h4>

            <button class="btn btn-info oculto-impresion" onclick="exportarExcel2()">EXPORTAR TABLA</button>


        </div>
    </div>



    <div class="row my-4 d-none">
        <div class="col">
            <h4 class="text-center display-4">CUADRES ORTODONCIA </h4>

            <table class="table table-hover" id="cauadres3" data-page-length="31">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Total A Cuadrar</th>
                        <th>Total en Efectivo</th>
                        <th>Total en Visas</th>
                        <th>Faltante</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                    $totalMes = 0;
                    @endphp
                    @foreach($cuadreOrto as $cau)
                    <tr>
                        <td>{{$cau->created_at}}</td>

                        <td>Q. {{number_format($cau->cuadre, 2)}}</td>
                        <td>Q. {{number_format($cau->totalEfectico, 2)}}</td>
                        <td>Q. {{number_format($cau->totalVisas, 2)}}</td>
                        <td>Q. {{number_format($cau->faltante, 2)}}</td>

                        @php
                        $aux = explode(" ", $cau->created_at);
                        $totalMes += $cau->cuadre;
                        @endphp



                    </tr>
                    @endforeach
                </tbody>
            </table>
            <h4>TOTAL EN CUADRES MEDICAMENTO: Q. {{number_format($totalMes,2)}}</h4>
            <button class="btn btn-info oculto-impresion" onclick="exportarExcel2()">EXPORTAR TABLA</button>

        </div>
    </div>


</div>
@endsection



@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.2/xlsx.full.min.js"></script>

<script>
    function exportarExcel() {
        var tabla = document.getElementById('cauadres');
        var wb = XLSX.utils.table_to_book(tabla, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, "Cuadre de Caja.xlsx");
    }

    function exportarExcel2() {
        var tabla = document.getElementById('cauadres2');
        var wb = XLSX.utils.table_to_book(tabla, {
            sheet: "Sheet1"
        });
        XLSX.writeFile(wb, "Cuadre Medicamento.xlsx");
    }
</script>

@endsection