@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col">

            <h4 class="card-title text-center display-4"> <br>
                Control de Artículos <?php echo date('d-M-Y') ?> <br>
            </h4>

            <div class="card">
                <div class="card-body">
                    <table class="table table-hover" id="table_id">
                        <thead>
                            <tr>
                                <th>Factura</th>
                                <th>Articulo </th>
                                <th>Cantidad</th>
                                <th>Fecha de Venta</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $total = 0; ?>
                            @foreach($articulos as $art)
                            <tr>
                                <td>{{$art->factura_id}}</td>
                                <td>{{$art->nomArt}} {{$art->descripcion}}</td>
                                <td>{{$art->cantidad}}</td>
                                <td>{{$art->fechaVenta}}</td>
                                <?php $total = $total + $art->cantidad; ?>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <div class="text-right mx-4">
                        <h2>Total de Artículos Vendidos: {{$total}}</h2>
                    </div>



                </div>


            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')

<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>
@endsection