@extends('layouts.app')
@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">
            <h4 class="card-title text-center display-4"><br>Articulos Registrados con Poca Existencia</h4>
            <div class="card">
                <div class="card-body">
                    <table class="table table-hover" id="tabla_id">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Descripción </th>
                                <th>Categoría</th>
                                <th>Precio Venta</th>
                                <th>Precio Costo</th>
                                <th>Stock</th>

                            </tr>
                        </thead>
                        <tbody>
                            @foreach($articulos as $art)
                            @if ($art->stock < $art->min_stock)
                                {{$total ++}}
                                <tr>
                                    <td>{{$art->nombre}}</td>
                                    <td>{{$art->descripcion}}</td>
                                    <td>{{$art->nomCat}}</td>
                                    <td>{{$art->p_venta}}</td>
                                    <td>{{$art->p_costo}}</td>
                                    <td>{{$art->stock}}</td>
                                </tr>
                                @endif
                                @endforeach
                        </tbody>
                    </table>

                    <div class="text-right mx-4">
                        <h2>Total de Articulos: {{$total}}</h2>
                    </div>


                </div>
            </div>
        </div>
    </div>
</div>

@endsection


@section('scripts')

<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#tabla_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>
@endsection