@extends('layouts.app')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">
            <h4 class="card-title text-center display-4"><br>Articulos Registrados</h4>
            <div class="card">
                <div class="card-body">
                    <table class="table table-hover" id="table_id" data-page-length="15">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Descripción </th>
                                <th>Categoría</th>
                                <th>Precio Venta</th>
                                <th>Precio Costo</th>
                                <th>Utilidad</th>
                                <th>Stock</th>

                            </tr>
                        </thead>
                        <tbody>

                            <?php $pventaTotal = 0;
                            $pcostoTotal = 0 ?>
                            @foreach($articulos as $art)
                            <tr>

                                <?php
                                $pventaTotal = $pventaTotal + ($art->p_venta * $art->stock);
                                $pcostoTotal = $pcostoTotal + ($art->p_costo * $art->stock);

                                ?>
                                <td>{{$art->nombre}}</td>
                                <td>{{$art->descripcion}}</td>
                                <td>{{$art->nomCat}}</td>
                                <td>{{$art->p_venta}}</td>
                                <td>{{$art->p_costo}}</td>
                                <td>{{$art->p_venta - $art->p_costo}}</td>
                                <td>{{$art->stock}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <div class="text-right mx-4">
                        <h2>Total de Tipos de Articulos: Q. {{number_format($total, 2)}}</h2>
                        <h2>Total de Precio Venta: Q. {{number_format($pventaTotal, 2)}}</h2>
                        <h2>Total de Precio Costo: Q. {{number_format($pcostoTotal, 2)}}</h2>
                        <h2>Total de Utilidad: Q. {{number_format($pventaTotal - $pcostoTotal, 2)}}</h2>
                    </div>




                </div>
            </div>
        </div>
    </div>
</div>

@endsection



@section('scripts')

<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<script>
    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',

            pageLength: 50000,

            order: [
                // [2, 'desc']
            ],

            "language": {
                "search": "BUSCAR DOCTOR",
            },

            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

        });

    });
</script>
@endsection